
# Remote Zabbix proxy health

## Overview

For Zabbix version: 6.0 and higher  

## Setup

Refer to the vendor documentation.

## Zabbix configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$ZABBIX.PROXY.ADDRESS} |<p>IP/DNS/network mask list of proxies to be remotely queried (default is 127.0.0.1).</p> |`127.0.0.1` |
|{$ZABBIX.PROXY.PORT} |<p>Port of proxy to be remotely queried (default is 10051).</p> |`10051` |
|{$ZABBIX.PROXY.UTIL.MAX} |<p>Maximum average percentage of time processes busy in the last minute (default is 75).</p> |`75` |
|{$ZABBIX.PROXY.UTIL.MIN} |<p>Minimum average percentage of time processes busy in the last minute (default is 65).</p> |`65` |

## Template links

There are no template links in this template.

## Discovery rules


## Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|Zabbix raw items |Remote Zabbix proxy: Zabbix stats |<p>Zabbix server statistics master item.</p> |INTERNAL |zabbix[stats,{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT}] |
|Zabbix proxy |Remote Zabbix proxy: Zabbix stats queue over 10m |<p>Number of monitored items in the queue which are delayed at least by 10 minutes.</p> |INTERNAL |zabbix[stats,{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT},queue,10m]<p>**Preprocessing**:</p><p>- JSONPATH: `$.queue`</p> |
|Zabbix proxy |Remote Zabbix proxy: Zabbix stats queue |<p>Number of monitored items in the queue which are delayed at least by 6 seconds.</p> |INTERNAL |zabbix[stats,{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT},queue]<p>**Preprocessing**:</p><p>- JSONPATH: `$.queue`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of data sender internal processes, in % |<p>Average percentage of time data sender processes have been busy in the last minute.</p> |DEPENDENT |process.data_sender.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['data sender'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes data sender not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of availability manager internal processes, in % |<p>Average percentage of time availability manager processes have been busy in the last minute.</p> |DEPENDENT |process.availability_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['availability manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes availability manager not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of configuration syncer internal processes, in % |<p>Average percentage of time configuration syncer processes have been busy in the last minute.</p> |DEPENDENT |process.configuration_syncer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['configuration syncer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes configuration syncer not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of discoverer data collector processes, in % |<p>Average percentage of time discoverer processes have been busy in the last minute.</p> |DEPENDENT |process.discoverer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['discoverer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes discoverer not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of heartbeat sender internal processes, in % |<p>Average percentage of time heartbeat sender processes have been busy in the last minute.</p> |DEPENDENT |process.heartbeat_sender.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['heartbeat sender'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes heartbeat sender not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of ODBC poller data collector processes, in % |<p>Average percentage of time ODBC poller processes have been busy in the last minute.</p> |DEPENDENT |process.odbc_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['odbc poller'].busy.avg`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of history poller data collector processes, in % |<p>Average percentage of time history poller processes have been busy in the last minute.</p> |DEPENDENT |process.history_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['history poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes history poller not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of history syncer internal processes, in % |<p>Average percentage of time history syncer processes have been busy in the last minute.</p> |DEPENDENT |process.history_syncer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['history syncer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes history syncer not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of housekeeper internal processes, in % |<p>Average percentage of time housekeeper processes have been busy in the last minute.</p> |DEPENDENT |process.housekeeper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['housekeeper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes housekeeper not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of http poller data collector processes, in % |<p>Average percentage of time http poller processes have been busy in the last minute.</p> |DEPENDENT |process.http_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['http poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes http poller not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of icmp pinger data collector processes, in % |<p>Average percentage of time icmp pinger processes have been busy in the last minute.</p> |DEPENDENT |process.icmp_pinger.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['icmp pinger'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes icmp pinger not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of ipmi manager internal processes, in % |<p>Average percentage of time ipmi manager processes have been busy in the last minute.</p> |DEPENDENT |process.ipmi_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['ipmi manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes ipmi manager not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of ipmi poller data collector processes, in % |<p>Average percentage of time ipmi poller processes have been busy in the last minute.</p> |DEPENDENT |process.ipmi_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['ipmi poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes ipmi poller not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of java poller data collector processes, in % |<p>Average percentage of time java poller processes have been busy in the last minute.</p> |DEPENDENT |process.java_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['java poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes java poller not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of poller data collector processes, in % |<p>Average percentage of time poller processes have been busy in the last minute.</p> |DEPENDENT |process.poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes poller not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of preprocessing worker internal processes, in % |<p>Average percentage of time preprocessing worker processes have been busy in the last minute.</p> |DEPENDENT |process.preprocessing_worker.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['preprocessing worker'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes preprocessing worker not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of preprocessing manager internal processes, in % |<p>Average percentage of time preprocessing manager processes have been busy in the last minute.</p> |DEPENDENT |process.preprocessing_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['preprocessing manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes preprocessing manager not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of self-monitoring internal processes, in % |<p>Average percentage of time self-monitoring processes have been busy in the last minute.</p> |DEPENDENT |process.self-monitoring.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['self-monitoring'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes self-monitoring not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of snmp trapper data collector processes, in % |<p>Average percentage of time snmp trapper processes have been busy in the last minute.</p> |DEPENDENT |process.snmp_trapper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['snmp trapper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes snmp trapper not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of task manager internal processes, in % |<p>Average percentage of time task manager processes have been busy in the last minute.</p> |DEPENDENT |process.task_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['task manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes task manager not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of trapper data collector processes, in % |<p>Average percentage of time trapper processes have been busy in the last minute.</p> |DEPENDENT |process.trapper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['trapper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes trapper not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of unreachable poller data collector processes, in % |<p>Average percentage of time unreachable poller processes have been busy in the last minute.</p> |DEPENDENT |process.unreachable_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['unreachable poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes unreachable poller not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Utilization of vmware data collector processes, in % |<p>Average percentage of time vmware collector processes have been busy in the last minute.</p> |DEPENDENT |process.vmware_collector.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['vmware collector'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes vmware collector not started`</p> |
|Zabbix proxy |Remote Zabbix proxy: Configuration cache, % used |<p>Availability statistics of Zabbix configuration cache. Percentage of used buffer.</p> |DEPENDENT |rcache.buffer.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.rcache.pused`</p> |
|Zabbix proxy |Remote Zabbix proxy: Version |<p>Version of Zabbix proxy.</p> |DEPENDENT |version<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.version`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Zabbix proxy |Remote Zabbix proxy: VMware cache, % used |<p>Availability statistics of Zabbix vmware cache. Percentage of used buffer.</p> |DEPENDENT |vmware.buffer.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vmware.pused`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No vmware collector processes started`</p> |
|Zabbix proxy |Remote Zabbix proxy: History write cache, % used |<p>Statistics and availability of Zabbix write cache. Percentage of used history buffer.</p><p>History cache is used to store item values. A high number indicates performance problems on the database side.</p> |DEPENDENT |wcache.history.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.history.pused`</p> |
|Zabbix proxy |Remote Zabbix proxy: History index cache, % used |<p>Statistics and availability of Zabbix write cache. Percentage of used history index buffer.</p><p>History index cache is used to index values stored in history cache.</p> |DEPENDENT |wcache.index.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.index.pused`</p> |
|Zabbix proxy |Remote Zabbix proxy: Number of processed values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Total number of values processed by Zabbix server or Zabbix proxy, except unsupported items.</p> |DEPENDENT |wcache.values<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.all`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix proxy |Remote Zabbix proxy: Number of processed numeric (float) values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed float values.</p> |DEPENDENT |wcache.values.float<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.float`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix proxy |Remote Zabbix proxy: Number of processed log values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed log values.</p> |DEPENDENT |wcache.values.log<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.log`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix proxy |Remote Zabbix proxy: Number of processed not supported values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of times item processing resulted in item becoming unsupported or keeping that state.</p> |DEPENDENT |wcache.values.not_supported<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values['not supported']`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix proxy |Remote Zabbix proxy: Number of processed character values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed character/string values.</p> |DEPENDENT |wcache.values.str<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.str`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix proxy |Remote Zabbix proxy: Number of processed text values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed text values.</p> |DEPENDENT |wcache.values.text<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.text`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix proxy |Remote Zabbix proxy: Preprocessing queue |<p>Count of values enqueued in the preprocessing queue.</p> |DEPENDENT |preprocessing_queue<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.preprocessing_queue`</p> |
|Zabbix proxy |Remote Zabbix proxy: Number of processed numeric (unsigned) values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed numeric (unsigned) values.</p> |DEPENDENT |wcache.values.uint<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.uint`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix proxy |Remote Zabbix proxy: Required performance |<p>Required performance of Zabbix proxy, in new values per second expected.</p> |DEPENDENT |requiredperformance<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.requiredperformance`</p> |
|Zabbix proxy |Remote Zabbix proxy: Uptime |<p>Uptime of Zabbix proxy process in seconds.</p> |DEPENDENT |uptime<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.uptime`</p> |

## Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|Remote Zabbix proxy: More than 100 items having missing data for more than 10 minutes |<p>zabbix[stats,{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT},queue,10m] item is collecting data about how many items are missing data for more than 10 minutes.</p> |`min(/Remote Zabbix proxy health/zabbix[stats,{$ZABBIX.PROXY.ADDRESS},{$ZABBIX.PROXY.PORT},queue,10m],10m)>100` |WARNING | |
|Remote Zabbix proxy: Utilization of data sender processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.data_sender.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"data sender"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.data_sender.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"data sender"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of availability manager processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.availability_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"availability manager"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.availability_manager.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"availability manager"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of configuration syncer processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.configuration_syncer.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"configuration syncer"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.configuration_syncer.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"configuration syncer"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of discoverer processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.discoverer.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"discoverer"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.discoverer.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"discoverer"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of heartbeat sender processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.heartbeat_sender.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"heartbeat sender"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.heartbeat_sender.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"heartbeat sender"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of ODBC poller processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.odbc_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"ODBC poller"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.odbc_poller.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"ODBC poller"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of history poller processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.history_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"history poller"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.history_poller.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"history poller"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of history syncer processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.history_syncer.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"history syncer"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.history_syncer.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"history syncer"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of housekeeper processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.housekeeper.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"housekeeper"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.housekeeper.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"housekeeper"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of http poller processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.http_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"http poller"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.http_poller.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"http poller"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of icmp pinger processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.icmp_pinger.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"icmp pinger"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.icmp_pinger.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"icmp pinger"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of ipmi manager processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.ipmi_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"ipmi manager"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.ipmi_manager.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"ipmi manager"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of ipmi poller processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.ipmi_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"ipmi poller"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.ipmi_poller.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"ipmi poller"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of java poller processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.java_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"java poller"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.java_poller.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"java poller"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of poller processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"poller"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.poller.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"poller"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of preprocessing worker processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.preprocessing_worker.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"preprocessing worker"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.preprocessing_worker.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"preprocessing worker"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of preprocessing manager processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.preprocessing_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"preprocessing manager"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.preprocessing_manager.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"preprocessing manager"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of self-monitoring processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.self-monitoring.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"self-monitoring"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.self-monitoring.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"self-monitoring"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of snmp trapper processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.snmp_trapper.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"snmp trapper"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.snmp_trapper.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"snmp trapper"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of task manager processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.task_manager.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"task manager"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.task_manager.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"task manager"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of trapper processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.trapper.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"trapper"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.trapper.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"trapper"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of unreachable poller processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.unreachable_poller.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"unreachable poller"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.unreachable_poller.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"unreachable poller"}` |AVERAGE | |
|Remote Zabbix proxy: Utilization of vmware collector processes is high |<p>-</p> |`avg(/Remote Zabbix proxy health/process.vmware_collector.avg.busy,10m)>{$ZABBIX.PROXY.UTIL.MAX:"vmware collector"}`<p>Recovery expression:</p>`avg(/Remote Zabbix proxy health/process.vmware_collector.avg.busy,10m)<{$ZABBIX.PROXY.UTIL.MIN:"vmware collector"}` |AVERAGE | |
|Remote Zabbix proxy: More than {$ZABBIX.PROXY.UTIL.MAX}% used in the configuration cache |<p>Consider increasing CacheSize in the zabbix_server.conf configuration file.</p> |`max(/Remote Zabbix proxy health/rcache.buffer.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX}` |AVERAGE | |
|Remote Zabbix proxy: Version has changed |<p>Remote Zabbix proxy version has changed. Ack to close.</p> |`last(/Remote Zabbix proxy health/version,#1)<>last(/Remote Zabbix proxy health/version,#2) and length(last(/Remote Zabbix proxy health/version))>0` |INFO |<p>Manual close: YES</p> |
|Remote Zabbix proxy: More than {$ZABBIX.PROXY.UTIL.MAX}% used in the vmware cache |<p>Consider increasing VMwareCacheSize in the zabbix_server.conf configuration file.</p> |`max(/Remote Zabbix proxy health/vmware.buffer.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX}` |AVERAGE | |
|Remote Zabbix proxy: More than {$ZABBIX.PROXY.UTIL.MAX}% used in the history cache |<p>Consider increasing HistoryCacheSize in the zabbix_server.conf configuration file.</p> |`max(/Remote Zabbix proxy health/wcache.history.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX}` |AVERAGE | |
|Remote Zabbix proxy: More than {$ZABBIX.PROXY.UTIL.MAX}% used in the history index cache |<p>Consider increasing HistoryIndexCacheSize in the zabbix_server.conf configuration file.</p> |`max(/Remote Zabbix proxy health/wcache.index.pused,10m)>{$ZABBIX.PROXY.UTIL.MAX}` |AVERAGE | |
|Remote Zabbix proxy: has been restarted |<p>Uptime is less than 10 minutes</p> |`last(/Remote Zabbix proxy health/uptime)<10m` |INFO |<p>Manual close: YES</p> |

## Feedback

Please report any issues with the template at https://support.zabbix.com

