# main
- New program:      StarCamera2Orbex (replaces GnssAttitude2Orbex).
- New program:      DoodsonHarmonicsChangePartialTides.
- New program:      Conversion: OceanTidesDTU2GriddedData.
- New program:      GnssResiduals2TransmitterAccuracyDefinition.
- New program:      SynthesisSphericalHarmonicsMatrix.
- New program:      Gravityfield2GravityVector.
- New class:        PlotDegreeAmplitudes: degreeAmplitudesSimple.
- New option:       GnssAntennaNormalsConstraint: gnssType selection for TEC constraint.
- New option:       PlotAxisLabeled: majorTickSpacing, minorTickSpacing, gridLineSpacing.
- New option:       GNSS/SLR: optional disabling of stations without precise apriori positions.
- File format:      TideGeneratingPotential includes now degree 3 tides.
- File format:      Each file is now readable/writable in JSON format as well.
- File format:      Removed deprecated GnssStationInfo (replaced by Platform).
- Bugfix:           GUI: fixed Ctrl+Shift+Up/Down for variables.
- Bugfix:           slrParametrizationRangeBiasStationSatellite: Fix station index.
- Bugfix:           parameterNames: fixed wrong order.
- Bugfix:           GraceAod2DoodsonHarmonics: fixed phase error.
- Bugfix:           GnssOrbex2StarCamera: reads now free format.
- Bugfix:           GnssNormals2Sinex: fixed parser error.
- Bugfix:           GnssParametrizationIonosphereSTEC: constant sigmaSTEC>0 was evaluated always to one.
- Bugfix:           ParameterVector2GnssAntennaDefinition: Sometimes the parameters were assigned incorrectly.
- Other:            GUI: offer links for numbers and strings of different types.
- Other:            GUI: Open multiple config files with the file selector.
- Other:            gnss: set margin for polynomial orbit interpolation to 1e-7 seconds.
- Other:            gnss: simulation considers more apriori models (e.g. TEC maps).
- Other:            IGRF: Updated International Geomagnetic Reference Field (IGRF) to 14th Generation Release
- Other:            GNSS: Improved setup of ambiguity parameters. Considers splitted network, splitted observations (e.g. L2LG, L2WG).
- Other:            GNSS: More stable estimation of ambiguities. Faster ambiguity resolution (decorrelation step).
- Other:            Store more double digits in xml format.
- Other:            NormalsEliminate: regularize unused eliminated parameters.
- Other:            Sinex2StationPosition: Apply frequencies to all intervals.


# Release 2024-06-24
- Interface change: Variables can now declared at any place in the config file (not only in the global section).
                    They have local scope within the hierarchy level.
                    Loop and conditions attributed to elements no longer need to be declared in the global section.
- SLR Processing:   New processing of SLR data with estimation of all relevant geodetic parameters.
  - New program:      SlrProcessing
  - New program:      conversion: Cpf2Orbit
  - New program:      conversion: Crd2NormalPoints
  - New program:      conversion: Cstg2NormalPoints
  - New program:      conversion: Merit2FullRate
  - New program:      conversion: Merit2NormalPoints
  - New program:      conversion: Orbit2Cpf
  - New program:      conversion: SinexEccentricties2SlrPlatform
  - New program:      conversion: SlrComModel2RangeBiasStationSatellite
  - New program:      conversion: SlrSinexDataHandling2Files
  - New class:        slrParametrization
  - New class:        slrProcessingStep
  - New class:        slrSatelliteGenerator
  - New class:        slrStationGenerator
  - New class:        In Troposphere: MendesAndPavlis
  - New instrument file format: SATELLITELASERRANGING
  - New instrument file format: METEOROLOGICAL
- New program:      eclipseFactor2GriddedData.cpp: returns a global grid with eclipse factors.
- New program:      orbit2EarhFixedOrbit: Rotate an orbit into a rotation earth fixed frame.
- New program:      GriddedDataTimeSeries2PotentialCoefficients.
- New program:      SinexMetadata2GlonassFrequencyNumber.
- New program:      SimulateStarCameraTerrasar.
- New class:        In PlatformSelector: Equipment.
- New class:        In Gravityfield/Tides/MiscAccelerations: Group.
- New option:       GnssAntennaDefinitionCreate: setZero and removeCenterMean.
- New option:       Sp3Fromat2Orbit: Write all satellites (identifier is appended to each file).
- New option:       GriddedData2PotentialCoefficients: Handle multiple input data columns at once.
- New option:       GriddedDataReduceSampling: tesseroid volume conserving for digital elevation models.
- New option:       Loop: optional condition for each loop step.
- New option:       gnssParametrizationStaticPositions: no net scale constraint.
- New option:       GnssProcessingStepResolveAmbiguities: partial ambiguity resolution with selectTransmitters/Receivers.
- New option:       GnssParametrizationCodeBiases: option to define ionosphere-free clock datum.
- New option:       GnssParametrizationIonosphereMap: option to read/write VTEC maps.
- New option:       PlatformSelector: new selection algorithm with exclude option.
- New option:       GoceXmlEggNom1b: write also linear common mode accelerations.
- Removed program:  GnssPrn2SvnBlockVariables: This program will no longer work from the next release! See documentation for help.
- Removed program:  NetCdf2PotentialCoefficients: Use NetCdf2GriddedDataTimeSeries and GriddedDataTimeSeries2PotentialCoefficients instead.
- Removed program:  Metop2Starcamera: Use Champ2AccStar instead.
- Bugfix:           GnssParametrizationStaticPositions: ignored inputfileNoNetPositions.
- Bugfix:           SphericalHarmonicsFilter->DDK: corrected filter for level 4 onwards (Compatible with ICGEM definition).
- Bugfix:           ObservationDeflections: fixed index bug.
- Bugfix:           NormalEquationFile: corrected contribution computation.
- Bugfix:           NetCdf: in some cases the data has been swapped.
- Bugfix:           GnssRinexNavigation2OrbitClock: reimplementation of source code.
- Other:            GnssAntennaDefinition2ParameterVector: with area weights.
- Other:            GnssAntex2AntennaDefinition/GnssGlonassFrequencyNumberUpdate: write Platform files instead of deprecated GnssStationInfo files.
- Other:            EarthRotation::rotaryAxis: if EOP time series is too short, use simplified equations.
- Other:            Gravityfield2Deflections: Computation based now on normal gravity.
- Other:            SimulateStarCamera: new optional nadir pointing mode.
- Other:            SimulateOrbit: Improved temporal numerical precision.
- Other:            GnssRinexNavigation2OrbitClock: add SBAS support.
- Other:            Updated documentation to explain parameter names.
- Other:            GriddedData: reworked area computations.
- Other:            IersC04IAU2000EarthOrientationParameter: works also with new file format.
- Other:            condition->fileExist: Supports now wildcards: * and ?.
- Other:            Champ2Orbit: simplified interface.

# Release 2023-08-25
- New program:      FileMove.
- New program:      FileTextCreate.
- New program:      InstrumentRemoveEpochsThruster.
- New program:      InstrumentApplyTimeOffset.
- New program:      InstrumentAccelerometerEstimateParameters (replaces InstrumentAccelerometerEstimateBiasScale).
- New program:      GraceOrbit2TransplantTimeOffset.
- New program:      GraceThrusterResponse2Accelerometer.
- New program:      GnssReceiver2RinexObservation.
- New program:      Sinex2StationPositions: replaces Sinex2StationPosition and Sinex2StationPostSeismicDeformation.
- New program:      ObservationEquations2Files.
- New program:      Variational2OrbitAndStarCamera (renamed Variational2Orbit): added possibility to also extract Earth rotation.
- New program:      PlatformCreate: replaces gnssStationInfoCreate.
- New program:      Tle2Orbit: Orbit from Two Line Elements (TLE).
- New program:      GriddedData2NetCdf, GriddedDataTimeSeries2NetCdf (replaces GridRectangular2NectCdf).
- New program:      NetCdf2GriddedData, NetCdf2GriddedDataTimeSeries (replaces NectCdf2DridRectangular).
- New program:      DoodsonAdmittance2SupplementaryFiles: for publication of ocean tide models.
- New program:      Gravityfield2TrendPotentialCoefficients: Estimate trend, annual, ...
- New class:        In Loop: DirectoryListing.
- New class:        In Loop: FileLines.
- New class:        In InstrumentResample/interpolatorTimeSeries: FillGapsLeastSquaresPolynomialFit.
- New class:        In MiscAccelerations: AtmosphericDragFromDensityFile.
- New class:        In MiscAccelerations: RadiationPressure, replaces SolarRadiatinPressure, Albedo
- New class:        In Loop: PlatformEquipment (replaces FileGnssStationInfo).
- Bugfix:           Gravityfield2Deflections: fixed initialization bug.
- Bugfix:           GnssRinexNavigation2OrbitClock: updated to be usable for rinex4 and fixes for rinex3.
- Bugfix:           Plot: various fixes for GMT Versions >6.1.
- Bugfix:           GriddedData: unwrap longitude before computing area elements.
- Bugfix:           InstrumentResample/polynomial: corrected interpolation vs. extrapolation.
- Bugfix:           GnssResiduals2Skyplot: consider also the PRN in type.
- Bugfix:           GssProcessingStepDisableTransmitterShadowEpochs.
- Bugfix:           Sinex2StationPositions: Correct sign for approx. positions.
- Other:            Reworked of GRACE-(FO) L1A conversion.
- Other:            GnssReceiver: Improved preprocessing (initial clock and cycleslip detection).
- Other:            GnssParametrizationStaticPositions: better selection of noNet stations.
- Other:            GnssParametrizationLeoDynamicOrbits: handling of mutliple arcs.
- Other:            GnssRinexNavigation2OrbitClock: works also for glonass.
- Other:            PlotMisc: set minimum size of points in legend to 3p.
- Other:            Preparation to replace GnssStationInfo file format by the more general Platform file format.
- Other:            Text parser: new {text/regex/replace}.
- Other:            GUI: added new multi-line comment elements, revised code.

# Release 2022-07-28
- New programs:     GriddedData2GriddedDataTimeSeries and GriddedDataTimeSeries2GriddedData.
- New programs:     MagneticField2GriddedData and Orbit2MagneticField.
- New class:        In MiscAccelerations: FromParametrization
- New option:       GnssAntennaDefinitionCreate: rename antennas.
- New option:       gnssReceiverGeneratorStationNetwork: inputfileClock.
- New option:       gnssReceiverGenerator: print preprocessing infos.
- New option:       GroupPrograms: silently and additional outputfileLog.
- New option:       MatrixGenerator->NormalsFile: observationCount.
- Bugfix:           instrument files: empty files are now compatible to other instrument types.
- Bugfix:           gnssProcessingStep: uninitialized normalEquationInfo.
- Bugfix:           gnssProcessingStep: wrong counting of observations.
- Bugfix:           gnssProcessingStepForEachReceiverSeparately: variableReceiver was not set.
- Bugfix:           gnssProcessingStepResolveAmbiguities: for writing empty ambiguity file.
- Bugfix:           gnssParametrizationClocksModel: Fixed zero mean constraint.
- Bugfix:           gnssParametrizationLeoDynamicOrbits: in parallel excecution.
- Bugfix:           gnssParametrizationKinematicPositions: in parallel excecution.
- Bugfix:           gnssTransmitter: noAntennaPatternFound->ignoreObservation not working correctly.
- Bugfix:           gnssReceiver: Simulating GLONASS ambiguities now correctly considers frequency channel.
- Bugfix:           sp3Format2Orbit: no/invalid orbit positions/velocities are now excluded.
- Bugfix:           Conversion of GRACE L1B/L1A data: revised source code.
- Bugfix:           loopFileAscii: Fixed uninitialized variable that could lead to the loop ending prematurely.
- Bugfix:           GnssAntex2AntennaDefinition: Fixed handling of frequency RMS blocks.
- Other:            File GriddedDataTimeSeries: includes now the last epoch; interval [...] instead of [...).
- Other:            File TimeSplinesGravityfield: includes now the last epoch; interval [...] instead of [...).
- Other:            Removed inputfileGlobal option.
- Other:            GnssAttitude2Orbex: can now handle different sampling per satellite.
- Other:            GnssRinexNavigation2OrbitClock/RinexObservation2GnssReceiver: Added basic support for RINEX v4.00.
- Other:            gnssParametrization*DynamicOrbits: integration starts and ends with first/last valid epoch.
- Other:            GnssLowEarthOrbiter: createTracks() before removing outlier epochs leads to less track splits.
- Other:            GUI: Added 'Open Documentation' to the context menu.

# Release 2021-09-06
- Interface change: Complete redesign of GnssProcessing to make usage a little bit easier and more flexible.
    - Direct use of orbits without integrating variational equations in case of fixed transmitters (e.g., PPP).
    - New class to add flexible parametrizations to the normal equation system.
    - New class to select transmitters/receivers for each parametrization.
    - Unified all transmitter classes into single class and merged all transmitter data and metadata into one folder at https://ftp.tugraz.at/outgoing/ITSG/groops/data/gnss/.
    - Example scenarios with config files at https://ftp.tugraz.at/outgoing/ITSG/groops/scenario/.
    - Updated and expanded documentation and cookbooks to reflect all GNSS-related changes.
- New program:      InstrumentAccelerometer2ThermosphericDensity: Estimate neutral density from accelerometer data.
- New class:        In Thermosphere: new model nrlmsis2
- New class:        In Condition: Matrix to evaluate matrix elements.
- New class:        In PlotMapProjection: added Mollweide map projection.
- Bugfix:           FileSatelliteModel: removed if-statement for shaded plates, not necessary when applying the algorithm following Sentman 1961
- Other:            Expression parser: constants are now defined with brackets, e.g pi().
- Other:            Additional constants in the mathematical parser like speed of light c().

# Release 2021-02-02
- Interface change: GnssProcessing, GnssSimulateReceiver: Removed intervals (use program within LoopPrograms instead).
- Interface change: SimulateStarCameraGnss: Full reimplementation with interface change.
                    Added support for all known attitude modes used by GPS, GLONASS, Galileo, BeiDou, and QZSS. Now requires GnssAttitudeInfo file.
- Interface change: Renamed program KalmanStaticTemporalNormals to NormalsBuildShortTimeStaticLongTime.
- New program:      GnssAttitudeInfoCreate: Creates attitude info file used by SimulateStarCameraGnss.
- New program:      PreprocessingDualSst: Analyze GRACE-FO KBR and LRI together.
- New class:        In Observation: DualSstVariational to use GRACE-FO KBR and LRI together.
- New class:        In ParametrizationGravity: LinearTransformation: Gravity field parametrization based on the linear transformation of another parametrizationGravity.
- New option:       LoopPrograms: processCountPerIteration (when running the loop on multiple processes), parallelLog (output to screen/log files from all processes).
- New option:       IfPrograms: elsePrograms (executed if condition evaluates to false).
- New option:       GroupPrograms: catchErrors (prevents program termination on error and optionally runs additional programs, i.e. try-catch).
- Bugfix:           Orbit2Kepler: Fixed angular output values (DEG2RAD -> RAD2DEG).
- Bugfix:           GnssClockRinex2InstrumentClock: 9-character identifier field width is now used starting from v3.04, not (incorrectly) from v3.00.
- Bugfix:           SphericalHarmonicsFilterMatrix: Input coefficient vector is now sorted correctly into filter matrix numbering.
- Bugfix:           MatrixDistributed: choleskyInverse(): Fixed a bug with sparse matrices.
- Bugfix:           Rectangular grids with one row or column (i.e. parallels or meridians) are now handled correctly.
- Bugfix:           InstrumentEstimateEmpiricalCovariance: Computation of autocovariance now works as expected.
- Bugfix:           Parallel: Multiple bugfixes and improvements for better support of different MPI implementations.
- Other:            Gnss: Updated BeiDou signal definition according to RINEX 3.05 and added support for BeiDou composite types.
- Other:            Sp3Format2Orbit: Added support for SP3d format.
- Other:            LoopPrograms: continueAfterError now works in parallel execution.
- Other:            Improved CMake installation process (see updated INSTALL.md). Now supports parallel compilation and install target.

# Release 2020-11-12
- Initial release
