/*
   wdt.h

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef _WDT_H_
#define _WDT_H_

#include <io.h>

#define wdt_reset() __asm__ __volatile__ ("wdr")

#define wdt_enable(timeout)				\
	__asm__ __volatile__ (				\
		"in __tmp_reg__, __SREG__" "\n\t"	\
		"cli" "\n\t"				\
		"wdr" "\n\t"				\
		"out %1, %0" "\n\t"			\
		"out __SREG__, __tmp_reg__" "\n\t"	\
		: /* no outputs */			\
		: "r" ((uint8_t)((timeout) | BV(WDE))),	\
		  "I" (WDTCR)				\
		: "r0"					\
	)

#define wdt_disable()					\
	__asm__ __volatile__ (				\
		"in __tmp_reg__, __SREG__" "\n\t"	\
		"cli" "\n\t"				\
		"wdr" "\n\t"				\
		"out %1, %0" "\n\t"			\
		"out %1, __zero_reg__" "\n\t"		\
		"out __SREG__, __tmp_reg__"		\
		: /* no outputs */			\
		: "r" (BV(WDTOE) | BV(WDE)),		\
		  "I" (WDTCR)				\
		: "r0"					\
	)

#endif
