/* vim: set sw=8 ts=8 si : */
/* Linux software to set the speed on the serial line 
* Written by Guido Socher 
* run this program like this:
* ttydevinit /dev/ttyS0 (for com1) and then use
* cat > /dev/ttyS0 to write or cat /dev/ttyS0 to read commands
* to/from the linuxlcdpannel */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>

int main(int argc, char *argv[])
{
	struct termios portset;
	char *device;
	int fd;

	if (argc != 2){
		printf("USAGE: ttydevinit /dev/ttyS1\n");
		exit(0);
	}
	device=argv[1];

        /* Set up io port correctly, and open it... */
        fd = open(device, O_RDWR | O_NOCTTY | O_NDELAY);
        if (fd == -1) {
                fprintf(stderr, "ERROR: open for %s failed.\n",device)
;
                exit(1);
        }
        tcgetattr(fd, &portset);
	cfmakeraw(&portset);
	cfsetospeed(&portset, B9600); /* speed */
	tcsetattr(fd, TCSANOW, &portset);
	close(fd);
	return(0);
}
