/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.elasticsearch.analysis.common.ESSolrSynonymParser;
import org.elasticsearch.analysis.common.ESWordnetSynonymParser;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.AnalysisMode;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;

public class SynonymTokenFilterFactory
extends AbstractTokenFilterFactory {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(SynonymTokenFilterFactory.class);
    private final String format;
    private final boolean expand;
    private final boolean lenient;
    protected final Settings settings;
    protected final Environment environment;
    protected final AnalysisMode analysisMode;

    SynonymTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.settings = settings;
        if (settings.get("ignore_case") != null) {
            DEPRECATION_LOGGER.deprecate("synonym_ignore_case_option", "The ignore_case option on the synonym_graph filter is deprecated. Instead, insert a lowercase filter in the filter chain before the synonym_graph filter.", new Object[0]);
        }
        this.expand = settings.getAsBoolean("expand", Boolean.valueOf(true));
        this.lenient = settings.getAsBoolean("lenient", Boolean.valueOf(false));
        this.format = settings.get("format", "");
        boolean updateable = settings.getAsBoolean("updateable", Boolean.valueOf(false));
        this.analysisMode = updateable ? AnalysisMode.SEARCH_TIME : AnalysisMode.ALL;
        this.environment = env;
    }

    public AnalysisMode getAnalysisMode() {
        return this.analysisMode;
    }

    public TokenStream create(TokenStream tokenStream) {
        throw new IllegalStateException("Call createPerAnalyzerSynonymFactory to specialize this factory for an analysis chain first");
    }

    public TokenFilterFactory getChainAwareTokenFilterFactory(TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> previousTokenFilters, Function<String, TokenFilterFactory> allFilters) {
        Analyzer analyzer = this.buildSynonymAnalyzer(tokenizer, charFilters, previousTokenFilters, allFilters);
        final SynonymMap synonyms = this.buildSynonyms(analyzer, this.getRulesFromSettings(this.environment));
        final String name = this.name();
        return new TokenFilterFactory(){

            public String name() {
                return name;
            }

            public TokenStream create(TokenStream tokenStream) {
                return synonyms.fst == null ? tokenStream : new SynonymFilter(tokenStream, synonyms, false);
            }

            public TokenFilterFactory getSynonymFilter() {
                return IDENTITY_FILTER;
            }

            public AnalysisMode getAnalysisMode() {
                return SynonymTokenFilterFactory.this.analysisMode;
            }
        };
    }

    Analyzer buildSynonymAnalyzer(TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> tokenFilters, Function<String, TokenFilterFactory> allFilters) {
        return new CustomAnalyzer(tokenizer, charFilters.toArray(new CharFilterFactory[0]), (TokenFilterFactory[])tokenFilters.stream().map(TokenFilterFactory::getSynonymFilter).toArray(TokenFilterFactory[]::new));
    }

    SynonymMap buildSynonyms(Analyzer analyzer, Reader rules) {
        try {
            Object parser;
            if ("wordnet".equalsIgnoreCase(this.format)) {
                parser = new ESWordnetSynonymParser(true, this.expand, this.lenient, analyzer);
                parser.parse(rules);
            } else {
                parser = new ESSolrSynonymParser(true, this.expand, this.lenient, analyzer);
                ((ESSolrSynonymParser)((Object)parser)).parse(rules);
            }
            return parser.build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to build synonyms", e);
        }
    }

    Reader getRulesFromSettings(Environment env) {
        Reader rulesReader;
        if (this.settings.getAsList("synonyms", null) != null) {
            List rulesList = Analysis.getWordList((Environment)env, (Settings)this.settings, (String)"synonyms");
            StringBuilder sb = new StringBuilder();
            for (String line : rulesList) {
                sb.append(line).append(System.lineSeparator());
            }
            rulesReader = new StringReader(sb.toString());
        } else if (this.settings.get("synonyms_path") != null) {
            rulesReader = Analysis.getReaderFromFile((Environment)env, (Settings)this.settings, (String)"synonyms_path");
        } else {
            throw new IllegalArgumentException("synonym requires either `synonyms` or `synonyms_path` to be configured");
        }
        return rulesReader;
    }
}

