/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.I2PSocketManagerFull;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Signature;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.ByteArrayStream;
import net.i2p.util.Log;

class Packet {
    protected final I2PSession _session;
    private long _sendStreamId;
    private long _receiveStreamId;
    private long _sequenceNum;
    private long _ackThrough;
    protected long[] _nacks;
    private int _resendDelay;
    private int _flags;
    private ByteArray _payload;
    protected Signature _optionSignature;
    protected Destination _optionFrom;
    private int _optionDelay;
    private int _optionMaxSize;
    protected long _transientExpires;
    protected Signature _offlineSignature;
    protected SigningPublicKey _transientSigningPublicKey;
    private int _localPort;
    private int _remotePort;
    public static final long STREAM_ID_UNKNOWN = 0L;
    public static final long MAX_STREAM_ID = 0xFFFFFFFFL;
    public static final int FLAG_SYNCHRONIZE = 1;
    public static final int FLAG_CLOSE = 2;
    public static final int FLAG_RESET = 4;
    public static final int FLAG_SIGNATURE_INCLUDED = 8;
    public static final int FLAG_SIGNATURE_REQUESTED = 16;
    public static final int FLAG_FROM_INCLUDED = 32;
    public static final int FLAG_DELAY_REQUESTED = 64;
    public static final int FLAG_MAX_PACKET_SIZE_INCLUDED = 128;
    public static final int FLAG_PROFILE_INTERACTIVE = 256;
    public static final int FLAG_ECHO = 512;
    public static final int FLAG_NO_ACK = 1024;
    public static final int FLAG_SIGNATURE_OFFLINE = 2048;
    public static final int DEFAULT_MAX_SIZE = 32768;
    protected static final int MAX_DELAY_REQUEST = 65535;
    public static final int MIN_DELAY_CHOKE = 60001;
    public static final int SEND_DELAY_CHOKE = 61000;
    private boolean _sendStreamIdSet = false;
    private boolean _receiveStreamIdSet = false;
    public static final int MAX_PAYLOAD_SIZE = 32768;

    public Packet(I2PSession session) {
        this._session = session;
    }

    public I2PSession getSession() {
        return this._session;
    }

    public long getSendStreamId() {
        return this._sendStreamId;
    }

    public void setSendStreamId(long id) {
        if (this._sendStreamIdSet && this._sendStreamId > 0L && this._sendStreamId != id) {
            throw new RuntimeException("Send stream ID already set [" + this._sendStreamId + ", " + id + "]");
        }
        this._sendStreamIdSet = true;
        this._sendStreamId = id;
    }

    public long getReceiveStreamId() {
        return this._receiveStreamId;
    }

    public void setReceiveStreamId(long id) {
        if (this._receiveStreamIdSet && this._receiveStreamId > 0L && this._receiveStreamId != id) {
            throw new RuntimeException("Receive stream ID already set [" + this._receiveStreamId + ", " + id + "]");
        }
        this._receiveStreamIdSet = true;
        this._receiveStreamId = id;
    }

    public long getSequenceNum() {
        return this._sequenceNum;
    }

    public void setSequenceNum(long num) {
        this._sequenceNum = num;
    }

    public long getAckThrough() {
        if (this.isFlagSet(1024)) {
            return -1L;
        }
        return this._ackThrough;
    }

    public void setAckThrough(long id) {
        if (id < 0L) {
            this.setFlag(1024);
        }
        this._ackThrough = id;
    }

    public long[] getNacks() {
        return this._nacks;
    }

    public void setNacks(long[] nacks) {
        this._nacks = nacks;
    }

    public int getResendDelay() {
        return this._resendDelay;
    }

    public void setResendDelay(int numSeconds) {
        this._resendDelay = numSeconds;
    }

    public ByteArray getPayload() {
        return this._payload;
    }

    public void setPayload(ByteArray payload) {
        this._payload = payload;
        if (payload != null && payload.getValid() > 32768) {
            throw new IllegalArgumentException("Too large payload: " + payload.getValid());
        }
    }

    public int getPayloadSize() {
        return this._payload == null ? 0 : this._payload.getValid();
    }

    public void releasePayload() {
    }

    public ByteArray acquirePayload() {
        this._payload = new ByteArray(new byte[32768]);
        return this._payload;
    }

    public boolean isFlagSet(int flag) {
        return 0 != (this._flags & flag);
    }

    public void setFlag(int flag) {
        this._flags |= flag;
    }

    public void setFlag(int flag, boolean set) {
        this._flags = set ? (this._flags |= flag) : (this._flags &= ~flag);
    }

    private void setFlags(int flags) {
        this._flags = flags;
    }

    public Signature getOptionalSignature() {
        return this._optionSignature;
    }

    public void setOptionalSignature(Signature sig) {
        this.setFlag(8, sig != null);
        this._optionSignature = sig;
    }

    public Destination getOptionalFrom() {
        return this._optionFrom;
    }

    public SigningPublicKey getTransientSPK() {
        return this._transientSigningPublicKey;
    }

    public int getOptionalDelay() {
        return this._optionDelay;
    }

    public void setOptionalDelay(int delayMs) {
        this._optionDelay = delayMs > 65535 ? 65535 : (delayMs < 0 ? 0 : delayMs);
    }

    public int getOptionalMaxSize() {
        return this._optionMaxSize;
    }

    public void setOptionalMaxSize(int numBytes) {
        this.setFlag(128, numBytes > 0);
        this._optionMaxSize = numBytes;
    }

    public int getLocalPort() {
        return this._localPort;
    }

    public void setLocalPort(int port) {
        this._localPort = port;
    }

    public int getRemotePort() {
        return this._remotePort;
    }

    public void setRemotePort(int port) {
        this._remotePort = port;
    }

    public int writePacket(byte[] buffer, int offset) throws IllegalStateException {
        return this.writePacket(buffer, offset, 0);
    }

    protected int writePacket(byte[] buffer, int offset, int fakeSigLen) throws IllegalStateException {
        int cur = offset;
        DataHelper.toLong((byte[])buffer, (int)cur, (int)4, (long)(this._sendStreamId >= 0L ? this._sendStreamId : 0L));
        DataHelper.toLong((byte[])buffer, (int)(cur += 4), (int)4, (long)(this._receiveStreamId >= 0L ? this._receiveStreamId : 0L));
        DataHelper.toLong((byte[])buffer, (int)(cur += 4), (int)4, (long)(this._sequenceNum > 0L ? this._sequenceNum : 0L));
        DataHelper.toLong((byte[])buffer, (int)(cur += 4), (int)4, (long)(this._ackThrough > 0L ? this._ackThrough : 0L));
        cur += 4;
        if (this._nacks != null) {
            DataHelper.toLong((byte[])buffer, (int)cur, (int)1, (long)this._nacks.length);
            ++cur;
            for (int i = 0; i < this._nacks.length; ++i) {
                DataHelper.toLong((byte[])buffer, (int)cur, (int)4, (long)this._nacks[i]);
                cur += 4;
            }
        } else {
            DataHelper.toLong((byte[])buffer, (int)cur, (int)1, (long)0L);
            ++cur;
        }
        DataHelper.toLong((byte[])buffer, (int)cur, (int)1, (long)(this._resendDelay > 0 ? (long)this._resendDelay : 0L));
        DataHelper.toLong((byte[])buffer, (int)(++cur), (int)2, (long)this._flags);
        cur += 2;
        int optionSize = 0;
        if (this.isFlagSet(64)) {
            optionSize += 2;
        }
        if (this.isFlagSet(32)) {
            optionSize += this._optionFrom.size();
        }
        if (this.isFlagSet(128)) {
            optionSize += 2;
        }
        if (this.isFlagSet(2048)) {
            optionSize += 6;
            optionSize += this._transientSigningPublicKey.length();
            optionSize += this._offlineSignature.length();
        }
        if (this.isFlagSet(8)) {
            if (fakeSigLen > 0) {
                optionSize += fakeSigLen;
            } else if (this._optionSignature != null) {
                optionSize += this._optionSignature.length();
            } else {
                throw new IllegalStateException();
            }
        }
        DataHelper.toLong((byte[])buffer, (int)cur, (int)2, (long)optionSize);
        cur += 2;
        if (this.isFlagSet(64)) {
            DataHelper.toLong((byte[])buffer, (int)cur, (int)2, (long)(this._optionDelay > 0 ? (long)this._optionDelay : 0L));
            cur += 2;
        }
        if (this.isFlagSet(32)) {
            cur += this._optionFrom.writeBytes(buffer, cur);
        }
        if (this.isFlagSet(128)) {
            DataHelper.toLong((byte[])buffer, (int)cur, (int)2, (long)(this._optionMaxSize > 0 ? (long)this._optionMaxSize : 32768L));
            cur += 2;
        }
        if (this.isFlagSet(2048)) {
            DataHelper.toLong((byte[])buffer, (int)cur, (int)4, (long)(this._transientExpires / 1000L));
            DataHelper.toLong((byte[])buffer, (int)(cur += 4), (int)2, (long)this._transientSigningPublicKey.getType().getCode());
            int len = this._transientSigningPublicKey.length();
            System.arraycopy(this._transientSigningPublicKey.getData(), 0, buffer, cur += 2, len);
            cur += len;
            len = this._offlineSignature.length();
            System.arraycopy(this._offlineSignature.getData(), 0, buffer, cur, len);
            cur += len;
        }
        if (this.isFlagSet(8)) {
            if (fakeSigLen == 0) {
                System.arraycopy(this._optionSignature.getData(), 0, buffer, cur, this._optionSignature.length());
                cur += this._optionSignature.length();
            } else {
                Arrays.fill(buffer, cur, cur + fakeSigLen, (byte)0);
                cur += fakeSigLen;
            }
        }
        if (this._payload != null) {
            try {
                System.arraycopy(this._payload.getData(), this._payload.getOffset(), buffer, cur, this._payload.getValid());
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                String error = "payload.length: " + this._payload.getValid() + " buffer.length: " + buffer.length + " cur: " + cur;
                I2PAppContext context = I2PAppContext.getCurrentContext();
                if (context != null) {
                    Log l = context.logManager().getLog(Packet.class);
                    l.log(40, error, (Throwable)aioobe);
                } else {
                    System.err.println(error);
                    aioobe.printStackTrace(System.out);
                }
                throw aioobe;
            }
            cur += this._payload.getValid();
        }
        return cur - offset;
    }

    private int writtenSize() {
        int size = 22;
        if (this._nacks != null) {
            size += 4 * this._nacks.length;
        }
        if (this.isFlagSet(64)) {
            size += 2;
        }
        if (this.isFlagSet(32)) {
            size += this._optionFrom.size();
        }
        if (this.isFlagSet(128)) {
            size += 2;
        }
        if (this.isFlagSet(8)) {
            size += this._optionSignature.length();
        }
        if (this.isFlagSet(2048)) {
            size += 6;
            size += this._transientSigningPublicKey.length();
            size += this._offlineSignature.length();
        }
        if (this._payload != null) {
            size += this._payload.getValid();
        }
        return size;
    }

    public void readPacket(byte[] buffer, int offset, int length) throws IllegalArgumentException {
        SigType type;
        if (buffer.length - offset < length) {
            throw new IllegalArgumentException("len=" + buffer.length + " off=" + offset + " length=" + length);
        }
        if (length < 22) {
            throw new IllegalArgumentException("Too small: len=" + buffer.length);
        }
        int cur = offset;
        this.setSendStreamId(DataHelper.fromLong((byte[])buffer, (int)cur, (int)4));
        this.setReceiveStreamId(DataHelper.fromLong((byte[])buffer, (int)(cur += 4), (int)4));
        this.setSequenceNum(DataHelper.fromLong((byte[])buffer, (int)(cur += 4), (int)4));
        this.setAckThrough(DataHelper.fromLong((byte[])buffer, (int)(cur += 4), (int)4));
        int numNacks = buffer[cur += 4] & 0xFF;
        ++cur;
        if (length < 22 + numNacks * 4) {
            throw new IllegalArgumentException("Too small with " + numNacks + " nacks: " + length);
        }
        if (numNacks > 0) {
            long[] nacks = new long[numNacks];
            for (int i = 0; i < numNacks; ++i) {
                nacks[i] = DataHelper.fromLong((byte[])buffer, (int)cur, (int)4);
                cur += 4;
            }
            this.setNacks(nacks);
        } else {
            this.setNacks(null);
        }
        this.setResendDelay(buffer[cur] & 0xFF);
        this.setFlags((int)DataHelper.fromLong((byte[])buffer, (int)(++cur), (int)2));
        int optionSize = (int)DataHelper.fromLong((byte[])buffer, (int)(cur += 2), (int)2);
        cur += 2;
        if (length < 22 + numNacks * 4 + optionSize) {
            throw new IllegalArgumentException("Too small with " + numNacks + " nacks and " + optionSize + " options: " + length);
        }
        int payloadBegin = cur + optionSize;
        int payloadSize = length - payloadBegin;
        if (payloadSize < 0 || payloadSize > 32768) {
            throw new IllegalArgumentException("length: " + length + " offset: " + offset + " begin: " + payloadBegin);
        }
        this._payload = new ByteArray(buffer, payloadBegin, payloadSize);
        if (this.isFlagSet(64)) {
            this.setOptionalDelay((int)DataHelper.fromLong((byte[])buffer, (int)cur, (int)2));
            cur += 2;
        }
        if (this.isFlagSet(32)) {
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer, cur, length - cur);
            try {
                Destination optionFrom = Destination.create((InputStream)bais);
                cur += optionFrom.size();
                this._optionFrom = optionFrom;
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Bad from field", ioe);
            }
            catch (DataFormatException dfe) {
                throw new IllegalArgumentException("Bad from field", dfe);
            }
        }
        if (this.isFlagSet(128)) {
            this.setOptionalMaxSize((int)DataHelper.fromLong((byte[])buffer, (int)cur, (int)2));
            cur += 2;
        }
        if (this.isFlagSet(2048)) {
            this._transientExpires = DataHelper.fromLong((byte[])buffer, (int)cur, (int)4) * 1000L;
            int itype = (int)DataHelper.fromLong((byte[])buffer, (int)(cur += 4), (int)2);
            cur += 2;
            type = SigType.getByCode((int)itype);
            if (type == null || !type.isAvailable()) {
                throw new IllegalArgumentException("Unsupported transient sig type: " + itype);
            }
            this._transientSigningPublicKey = new SigningPublicKey(type);
            byte[] buf = new byte[this._transientSigningPublicKey.length()];
            System.arraycopy(buffer, cur, buf, 0, buf.length);
            this._transientSigningPublicKey.setData(buf);
            cur += buf.length;
            if (this._optionFrom == null) {
                throw new IllegalArgumentException("TODO offline w/o FROM");
            }
            type = this._optionFrom.getSigningPublicKey().getType();
            this._offlineSignature = new Signature(type);
            buf = new byte[this._offlineSignature.length()];
            System.arraycopy(buffer, cur, buf, 0, buf.length);
            this._offlineSignature.setData(buf);
            cur += buf.length;
        }
        if (this.isFlagSet(8)) {
            Signature optionSignature;
            if (this._optionFrom != null) {
                type = this.isFlagSet(2048) ? this._transientSigningPublicKey.getType() : this._optionFrom.getSigningPublicKey().getType();
                optionSignature = new Signature(type);
            } else {
                int siglen = payloadBegin - cur;
                SigType type2 = null;
                for (SigType t : SigType.values()) {
                    if (t.getSigLen() != siglen) continue;
                    type2 = t;
                    break;
                }
                if (type2 == null) {
                    if (siglen < Signature.SIGNATURE_BYTES) {
                        throw new IllegalArgumentException("unknown sig type len=" + siglen);
                    }
                    type2 = SigType.DSA_SHA1;
                    siglen = Signature.SIGNATURE_BYTES;
                }
                optionSignature = new Signature(type2);
            }
            byte[] buf = new byte[optionSignature.length()];
            System.arraycopy(buffer, cur, buf, 0, buf.length);
            optionSignature.setData(buf);
            this.setOptionalSignature(optionSignature);
            cur += buf.length;
        }
    }

    public boolean verifySignature(I2PAppContext ctx, byte[] buffer) {
        return this.verifySignature(ctx, null, buffer);
    }

    public boolean verifySignature(I2PAppContext ctx, SigningPublicKey altSPK, byte[] buffer) {
        Log l;
        boolean ok;
        SigType type;
        SigningPublicKey spk;
        if (!this.isFlagSet(8)) {
            return false;
        }
        if (this._optionSignature == null) {
            return false;
        }
        SigningPublicKey signingPublicKey = spk = this._optionFrom != null ? this._optionFrom.getSigningPublicKey() : altSPK;
        if (spk == null) {
            return false;
        }
        int size = this.writtenSize();
        if (buffer == null) {
            buffer = new byte[size];
        }
        if (this.isFlagSet(2048)) {
            if (this._transientExpires < ctx.clock().now()) {
                Log l2 = ctx.logManager().getLog(Packet.class);
                if (l2.shouldLog(30)) {
                    l2.warn("Offline signature expired " + this.toString());
                }
                return false;
            }
            ByteArrayStream baos = new ByteArrayStream(6 + this._transientSigningPublicKey.length());
            try {
                DataHelper.writeLong((OutputStream)baos, (int)4, (long)(this._transientExpires / 1000L));
                DataHelper.writeLong((OutputStream)baos, (int)2, (long)this._transientSigningPublicKey.getType().getCode());
                this._transientSigningPublicKey.writeBytes((OutputStream)baos);
            }
            catch (IOException ioe) {
                return false;
            }
            catch (DataFormatException dfe) {
                return false;
            }
            boolean ok2 = baos.verifySignature(ctx, this._offlineSignature, spk);
            if (!ok2) {
                Log l3 = ctx.logManager().getLog(Packet.class);
                if (l3.shouldLog(30)) {
                    l3.warn("Offline signature failed on " + this.toString());
                }
                return false;
            }
            spk = this._transientSigningPublicKey;
        }
        if ((type = spk.getType()) == null || !type.isAvailable()) {
            Log l4 = ctx.logManager().getLog(Packet.class);
            if (l4.shouldLog(30)) {
                l4.warn("Unknown sig type in " + spk + " cannot verify " + this.toString());
            }
            return false;
        }
        int written = this.writePacket(buffer, 0, type.getSigLen());
        if (written != size) {
            ctx.logManager().getLog(Packet.class).error("Written " + written + " size " + size + " for " + this.toString(), (Throwable)new Exception("moo"));
            return false;
        }
        if (type != this._optionSignature.getType() && type.getSigLen() == this._optionSignature.length()) {
            this._optionSignature = new Signature(type, this._optionSignature.getData());
        }
        try {
            ok = ctx.dsa().verifySignature(this._optionSignature, buffer, 0, size, spk);
        }
        catch (IllegalArgumentException iae) {
            Log l5 = ctx.logManager().getLog(Packet.class);
            if (l5.shouldLog(30)) {
                l5.warn("Signature failed on " + this.toString(), (Throwable)iae);
            }
            ok = false;
        }
        if (!ok && (l = ctx.logManager().getLog(Packet.class)).shouldLog(30)) {
            l.warn("Signature failed on " + this.toString() + " using SPK " + spk);
        }
        return ok;
    }

    public String toString() {
        StringBuilder str = this.formatAsString();
        return str.toString();
    }

    protected StringBuilder formatAsString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(Packet.toId(this._sendStreamId));
        buf.append('/');
        buf.append(Packet.toId(this._receiveStreamId)).append(':');
        if (this._sequenceNum != 0L || this.isFlagSet(1)) {
            buf.append(" #").append(this._sequenceNum);
        }
        this.toFlagString(buf);
        if (this._payload != null && this._payload.getValid() > 0) {
            buf.append(" data: ").append(this._payload.getValid());
        }
        return buf;
    }

    static final String toId(long id) {
        return Base64.encode((byte[])DataHelper.toLong((int)4, (long)id)).replace("==", "");
    }

    private final void toFlagString(StringBuilder buf) {
        if (this.isFlagSet(1)) {
            buf.append(" SYN");
        }
        if (this.isFlagSet(2)) {
            buf.append(" CLOSE");
        }
        if (this.isFlagSet(4)) {
            buf.append(" RESET");
        }
        if (this.isFlagSet(512)) {
            buf.append(" ECHO");
        }
        if (this.isFlagSet(32)) {
            buf.append(" FROM ").append(this._optionFrom.size());
        }
        if (this.isFlagSet(1024)) {
            buf.append(" NO_ACK");
        } else {
            buf.append(" ACK ").append(this.getAckThrough());
        }
        if (this._nacks != null) {
            buf.append(" NACK");
            for (int i = 0; i < this._nacks.length; ++i) {
                buf.append(' ').append(this._nacks[i]);
            }
        }
        if (this.isFlagSet(64)) {
            buf.append(" DELAY ").append(this._optionDelay);
        }
        if (this.isFlagSet(128)) {
            buf.append(" MS ").append(this._optionMaxSize);
        }
        if (this.isFlagSet(256)) {
            buf.append(" INTERACTIVE");
        }
        if (this.isFlagSet(16)) {
            buf.append(" SIGREQ");
        }
        if (this.isFlagSet(2048)) {
            if (this._transientExpires != 0L) {
                buf.append(" TRANSEXP ").append(new Date(this._transientExpires));
            } else {
                buf.append(" (no expiration)");
            }
            if (this._transientSigningPublicKey != null) {
                buf.append(" TRANSKEY ").append(this._transientSigningPublicKey.getType()).append(':').append(this._transientSigningPublicKey.toBase64());
            } else {
                buf.append(" (no key data)");
            }
            if (this._offlineSignature != null) {
                buf.append(" OFFSIG ").append(this._offlineSignature.getType());
            } else {
                buf.append(" (no offline sig data)");
            }
        }
        if (this.isFlagSet(8)) {
            if (this._optionSignature != null) {
                buf.append(" SIG ").append(this._optionSignature.getType());
            } else {
                buf.append(" (to be signed)");
            }
        }
    }

    public void logTCPDump(Connection con) {
        try {
            I2PSocketManagerFull.pcapWriter.write(this, con);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

