/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.rrd4j.core.RrdBackendFactory;

public abstract class RrdFileBackendFactory
extends RrdBackendFactory {
    @Override
    protected boolean exists(String path) {
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    @Override
    public boolean canStore(URI uri) {
        if ((uri.isOpaque() || uri.isAbsolute()) && !"file".equals(uri.getScheme())) {
            return false;
        }
        return uri.getAuthority() == null && uri.getFragment() == null && uri.getQuery() == null;
    }

    @Override
    public URI getCanonicalUri(URI uri) {
        try {
            Path file = uri.isOpaque() || uri.getScheme() == null ? Paths.get(uri.getSchemeSpecificPart(), new String[0]) : Paths.get(uri);
            Path parent = file.getParent().toRealPath(new LinkOption[0]);
            return parent.resolve(file.getFileName()).toUri();
        }
        catch (IOError | IOException e) {
            throw new IllegalArgumentException("can't get canonical URI from " + uri + ": " + e, e);
        }
    }

    @Override
    public URI getUri(String path) {
        try {
            return Paths.get(path, new String[0]).normalize().toUri();
        }
        catch (IOError e) {
            throw new IllegalArgumentException("can't get URI from path " + path + ": " + e, e);
        }
    }

    @Override
    public String getPath(URI uri) {
        if (uri.isOpaque()) {
            return uri.getSchemeSpecificPart();
        }
        if (uri.isAbsolute()) {
            return Paths.get(uri).normalize().toString();
        }
        return uri.getPath();
    }
}

