/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.desktopgui;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;
import net.i2p.I2PAppContext;
import net.i2p.apps.systray.UrlLauncher;
import net.i2p.data.DataHelper;
import net.i2p.desktopgui.Main;
import net.i2p.desktopgui.TrayManager;
import net.i2p.desktopgui.router.RouterManager;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.Translate;

class InternalTrayManager
extends TrayManager {
    private final RouterContext _context;
    private final Log log;
    private MenuItem _statusItem;
    private MenuItem _browserItem;
    private MenuItem _configItem;
    private MenuItem _restartItem;
    private MenuItem _stopItem;
    private MenuItem _restartHardItem;
    private MenuItem _stopHardItem;
    private MenuItem _cancelItem;
    private MenuItem _notificationItem1;
    private MenuItem _notificationItem2;
    private JMenuItem _jstatusItem;
    private JMenuItem _jbrowserItem;
    private JMenuItem _jconfigItem;
    private JMenuItem _jrestartItem;
    private JMenuItem _jstopItem;
    private JMenuItem _jrestartHardItem;
    private JMenuItem _jstopHardItem;
    private JMenuItem _jcancelItem;
    private JMenuItem _jnotificationItem1;
    private JMenuItem _jnotificationItem2;
    private static final boolean CONSOLE_ENABLED = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
    private static final String CONSOLE_BUNDLE_NAME = "net.i2p.router.web.messages";

    public InternalTrayManager(RouterContext ctx, Main main, boolean useSwing) {
        super(ctx, main, useSwing);
        this._context = ctx;
        this.log = ctx.logManager().getLog(InternalTrayManager.class);
    }

    @Override
    public void startManager() throws AWTException {
        super.startManager();
        this.displayMessage(20, this._t("Starting"), this._t("I2P is starting!"), null);
    }

    @Override
    public synchronized PopupMenu getMainMenu() {
        MenuItem restartItem2;
        MenuItem restartItem;
        MenuItem browserLauncher;
        PopupMenu popup = new PopupMenu();
        MenuItem statusItem = new MenuItem("");
        if (CONSOLE_ENABLED) {
            browserLauncher = new MenuItem(this._t("Launch I2P Browser"));
            browserLauncher.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            return null;
                        }

                        @Override
                        protected void done() {
                            InternalTrayManager.this.launchBrowser();
                        }
                    }.execute();
                }
            });
        } else {
            browserLauncher = null;
        }
        PopupMenu desktopguiConfigurationLauncher = new PopupMenu(this._t("Configure I2P System Tray"));
        MenuItem notificationItem2 = new MenuItem(this._t("Enable notifications"));
        notificationItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        InternalTrayManager.this.configureNotifications(true);
                        return null;
                    }
                }.execute();
            }
        });
        MenuItem notificationItem1 = new MenuItem(this._t("Disable notifications"));
        notificationItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        InternalTrayManager.this.configureNotifications(false);
                        return null;
                    }
                }.execute();
            }
        });
        MenuItem configSubmenu = new MenuItem(this._t("Disable system tray"));
        configSubmenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        InternalTrayManager.this.configureDesktopgui(false);
                        return null;
                    }
                }.execute();
            }
        });
        if (this._context.hasWrapper()) {
            restartItem = new MenuItem(this._t("Restart I2P"));
            restartItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            RouterManager.restartGracefully(InternalTrayManager.this._context);
                            return null;
                        }
                    }.execute();
                }
            });
        } else {
            restartItem = null;
        }
        MenuItem stopItem = new MenuItem(this._t("Stop I2P"));
        stopItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        RouterManager.shutDownGracefully(InternalTrayManager.this._context);
                        return null;
                    }
                }.execute();
            }
        });
        if (this._context.hasWrapper()) {
            restartItem2 = new MenuItem(this._t("Restart I2P Immediately"));
            restartItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            RouterManager.restart(InternalTrayManager.this._context);
                            return null;
                        }
                    }.execute();
                }
            });
        } else {
            restartItem2 = null;
        }
        MenuItem stopItem2 = new MenuItem(this._t("Stop I2P Immediately"));
        stopItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        RouterManager.shutDown(InternalTrayManager.this._context);
                        return null;
                    }
                }.execute();
            }
        });
        MenuItem cancelItem = new MenuItem(this._t("Cancel I2P Shutdown"));
        cancelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        RouterManager.cancelShutdown(InternalTrayManager.this._context);
                        return null;
                    }
                }.execute();
            }
        });
        popup.add(statusItem);
        popup.addSeparator();
        if (CONSOLE_ENABLED) {
            popup.add(browserLauncher);
            popup.addSeparator();
        }
        desktopguiConfigurationLauncher.add(notificationItem2);
        desktopguiConfigurationLauncher.add(notificationItem1);
        desktopguiConfigurationLauncher.add(configSubmenu);
        popup.add(desktopguiConfigurationLauncher);
        popup.addSeparator();
        if (this._context.hasWrapper()) {
            popup.add(restartItem);
        }
        popup.add(stopItem);
        if (this._context.hasWrapper()) {
            popup.add(restartItem2);
        }
        popup.add(stopItem2);
        popup.add(cancelItem);
        this._statusItem = statusItem;
        this._browserItem = browserLauncher;
        this._configItem = desktopguiConfigurationLauncher;
        this._notificationItem1 = notificationItem1;
        this._notificationItem2 = notificationItem2;
        this._restartItem = restartItem;
        this._stopItem = stopItem;
        this._restartHardItem = restartItem2;
        this._stopHardItem = stopItem2;
        this._cancelItem = cancelItem;
        return popup;
    }

    @Override
    public synchronized JPopupMenu getSwingMainMenu() {
        JMenuItem restartItem2;
        JMenuItem restartItem;
        JMenuItem browserLauncher;
        JPopupMenu popup = new JPopupMenu();
        JMenuItem statusItem = new JMenuItem("");
        if (CONSOLE_ENABLED) {
            browserLauncher = new JMenuItem(this._t("Launch I2P Browser"));
            browserLauncher.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            return null;
                        }

                        @Override
                        protected void done() {
                            InternalTrayManager.this.launchBrowser();
                        }
                    }.execute();
                }
            });
        } else {
            browserLauncher = null;
        }
        JMenu desktopguiConfigurationLauncher = new JMenu(this._t("Configure I2P System Tray"));
        JMenuItem notificationItem2 = new JMenuItem(this._t("Enable notifications"));
        notificationItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        InternalTrayManager.this.configureNotifications(true);
                        return null;
                    }
                }.execute();
            }
        });
        JMenuItem notificationItem1 = new JMenuItem(this._t("Disable notifications"));
        notificationItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        InternalTrayManager.this.configureNotifications(false);
                        return null;
                    }
                }.execute();
            }
        });
        JMenuItem configSubmenu = new JMenuItem(this._t("Disable system tray"));
        configSubmenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        InternalTrayManager.this.configureDesktopgui(false);
                        return null;
                    }
                }.execute();
            }
        });
        if (this._context.hasWrapper()) {
            restartItem = new JMenuItem(this._t("Restart I2P"));
            restartItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            RouterManager.restartGracefully(InternalTrayManager.this._context);
                            return null;
                        }
                    }.execute();
                }
            });
        } else {
            restartItem = null;
        }
        JMenuItem stopItem = new JMenuItem(this._t("Stop I2P"));
        stopItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        RouterManager.shutDownGracefully(InternalTrayManager.this._context);
                        return null;
                    }
                }.execute();
            }
        });
        if (this._context.hasWrapper()) {
            restartItem2 = new JMenuItem(this._t("Restart I2P Immediately"));
            restartItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            RouterManager.restart(InternalTrayManager.this._context);
                            return null;
                        }
                    }.execute();
                }
            });
        } else {
            restartItem2 = null;
        }
        JMenuItem stopItem2 = new JMenuItem(this._t("Stop I2P Immediately"));
        stopItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        RouterManager.shutDown(InternalTrayManager.this._context);
                        return null;
                    }
                }.execute();
            }
        });
        JMenuItem cancelItem = new JMenuItem(this._t("Cancel I2P Shutdown"));
        cancelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        RouterManager.cancelShutdown(InternalTrayManager.this._context);
                        return null;
                    }
                }.execute();
            }
        });
        popup.add(statusItem);
        popup.addSeparator();
        if (CONSOLE_ENABLED) {
            popup.add(browserLauncher);
            popup.addSeparator();
        }
        desktopguiConfigurationLauncher.add(notificationItem2);
        desktopguiConfigurationLauncher.add(notificationItem1);
        desktopguiConfigurationLauncher.add(configSubmenu);
        popup.add(desktopguiConfigurationLauncher);
        popup.addSeparator();
        if (this._context.hasWrapper()) {
            popup.add(restartItem);
        }
        popup.add(stopItem);
        if (this._context.hasWrapper()) {
            popup.add(restartItem2);
        }
        popup.add(stopItem2);
        popup.add(cancelItem);
        this._jstatusItem = statusItem;
        this._jbrowserItem = browserLauncher;
        this._jconfigItem = desktopguiConfigurationLauncher;
        this._jnotificationItem1 = notificationItem1;
        this._jnotificationItem2 = notificationItem2;
        this._jrestartItem = restartItem;
        this._jstopItem = stopItem;
        this._jrestartHardItem = restartItem2;
        this._jstopHardItem = stopItem2;
        this._jcancelItem = cancelItem;
        return popup;
    }

    @Override
    protected synchronized void updateMenu() {
        MenuItem item;
        String oldStatus;
        String status;
        boolean x = RouterManager.isShutdownInProgress(this._context);
        boolean imminent = false;
        if (x) {
            long time = RouterManager.getShutdownTimeRemaining(this._context);
            if (time > 5000L) {
                status = this._t("Shutdown in {0}", DataHelper.formatDuration2(time).replace("&nbsp;", " "));
            } else {
                status = this._t("Shutdown imminent");
                imminent = true;
            }
        } else {
            status = this._t("Network") + ": " + Translate.getString(RouterManager.getStatus(this._context), this._context, CONSOLE_BUNDLE_NAME);
        }
        PopupMenu awt = this.trayIcon.getPopupMenu();
        if (awt != null && !status.equals(oldStatus = (item = awt.getItem(0)).getLabel())) {
            item.setLabel(status);
        }
        if (this._browserItem != null) {
            this._browserItem.setEnabled(!imminent);
        }
        if (this._configItem != null) {
            this._configItem.setEnabled(!imminent);
        }
        if (this._restartItem != null) {
            this._restartItem.setEnabled(!x);
        }
        if (this._stopItem != null) {
            this._stopItem.setEnabled(!x);
        }
        if (this._restartHardItem != null) {
            this._restartHardItem.setEnabled(!imminent);
        }
        if (this._stopHardItem != null) {
            this._stopHardItem.setEnabled(!imminent);
        }
        if (this._cancelItem != null) {
            this._cancelItem.setEnabled(x && !imminent);
        }
        if (this._notificationItem1 != null) {
            this._notificationItem1.setEnabled(this._showNotifications);
        }
        if (this._notificationItem2 != null) {
            this._notificationItem2.setEnabled(!this._showNotifications);
        }
        if (this._jstatusItem != null) {
            this._jstatusItem.setText(status);
        }
        if (this._jbrowserItem != null) {
            this._jbrowserItem.setVisible(!imminent);
        }
        if (this._jconfigItem != null) {
            this._jconfigItem.setVisible(!imminent);
        }
        if (this._jrestartItem != null) {
            this._jrestartItem.setVisible(!x);
        }
        if (this._jstopItem != null) {
            this._jstopItem.setVisible(!x);
        }
        if (this._jrestartHardItem != null) {
            this._jrestartHardItem.setVisible(!imminent);
        }
        if (this._jstopHardItem != null) {
            this._jstopHardItem.setVisible(!imminent);
        }
        if (this._jcancelItem != null) {
            this._jcancelItem.setVisible(x && !imminent);
        }
        if (this._jnotificationItem1 != null) {
            this._jnotificationItem1.setVisible(this._showNotifications);
        }
        if (this._jnotificationItem2 != null) {
            this._jnotificationItem2.setVisible(!this._showNotifications);
        }
    }

    private void configureDesktopgui(boolean enable) {
        String property = "desktopgui.enabled";
        String value = Boolean.toString(enable);
        if (!this._context.router().saveConfig(property, value)) {
            this.log.error("Error saving config");
        }
        if (!enable) {
            this._main.shutdown(null);
        }
    }

    private void configureNotifications(boolean enable) {
        this._showNotifications = enable;
        String value = Boolean.toString(enable);
        if (!this._context.router().saveConfig("desktopgui.showNotifications", value)) {
            this.log.error("Error saving config");
        }
    }

    private void launchBrowser() {
        UrlLauncher launcher = new UrlLauncher((I2PAppContext)this._context, null, null);
        String url = this._context.portMapper().getConsoleURL();
        try {
            launcher.openUrl(url);
        }
        catch (IOException e1) {
            this.log.log(30, "Failed to open browser!", e1);
        }
    }
}

