/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RawArgs
implements Iterable<Entry> {
    private List<Entry> args = new ArrayList<Entry>();

    public void addAll(List<String> lines, Path sourceFile) {
        String source = sourceFile.toAbsolutePath().toString();
        for (String line : lines) {
            this.addArg(line, source);
        }
    }

    public void addArg(String rawline, String source) {
        if (rawline == null) {
            return;
        }
        String line = rawline.trim();
        if (line.length() == 0) {
            return;
        }
        this.args.add(new Entry(line, source));
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.args.iterator();
    }

    public int size() {
        return this.args.size();
    }

    public class Entry {
        private String line;
        private String origin;

        private Entry(String line, String origin) {
            this.line = line;
            this.origin = origin;
        }

        public String getLine() {
            return this.line;
        }

        public String getOrigin() {
            return this.origin;
        }

        public boolean startsWith(String val) {
            return this.line.startsWith(val);
        }
    }
}

