/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.AlpnExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.alpn.AlpnEntry;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.alpn.AlpnEntryPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.alpn.AlpnEntrySerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlpnExtensionPreparator
extends ExtensionPreparator<AlpnExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final AlpnExtensionMessage msg;

    public AlpnExtensionPreparator(Chooser chooser, AlpnExtensionMessage message, ExtensionSerializer<AlpnExtensionMessage> serializer) {
        super(chooser, message, serializer);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (AlpnEntry entry : this.msg.getAlpnEntryList()) {
            AlpnEntryPreparator preparator = new AlpnEntryPreparator(this.chooser, entry);
            preparator.prepare();
            AlpnEntrySerializer serializer = new AlpnEntrySerializer(entry);
            try {
                stream.write(serializer.serialize());
            }
            catch (IOException ex) {
                LOGGER.warn("Could not serialize AlpnEntry");
            }
        }
        this.msg.setAlpnAnnouncedProtocols(stream.toByteArray());
        LOGGER.debug("Prepared the ALPN Extension with announced protocols " + ArrayConverter.bytesToHexString((ModifiableByteArray)this.msg.getAlpnAnnouncedProtocols()));
        this.msg.setAlpnExtensionLength(((byte[])this.msg.getAlpnAnnouncedProtocols().getValue()).length);
        LOGGER.debug("Prepared the ALPN Extension with announced protocols length " + this.msg.getAlpnExtensionLength().getValue());
    }
}

