/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.security.PermitAll;
import javax.mail.MessagingException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.velocity.VelocityContext;
import org.traccar.Context;
import org.traccar.api.BaseResource;
import org.traccar.model.User;
import org.traccar.notification.NotificationMessage;
import org.traccar.notification.TextTemplateFormatter;

@Path(value="password")
@Produces(value={"application/json"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class PasswordResource
extends BaseResource {
    private static final String PASSWORD_RESET_TOKEN = "passwordToken";

    @Path(value="reset")
    @PermitAll
    @POST
    public Response reset(@FormParam(value="email") String email) throws SQLException, MessagingException {
        for (long userId : Context.getUsersManager().getAllItems()) {
            User user = (User)Context.getUsersManager().getById(userId);
            if (!email.equals(user.getEmail())) continue;
            String token = UUID.randomUUID().toString().replaceAll("-", "");
            user.set(PASSWORD_RESET_TOKEN, token);
            Context.getUsersManager().updateItem(user);
            VelocityContext velocityContext = TextTemplateFormatter.prepareContext(null);
            velocityContext.put("token", (Object)token);
            NotificationMessage fullMessage = TextTemplateFormatter.formatMessage(velocityContext, "passwordReset", "full");
            Context.getMailManager().sendMessage(userId, fullMessage.getSubject(), fullMessage.getBody());
            break;
        }
        return Response.ok().build();
    }

    @Path(value="update")
    @PermitAll
    @POST
    public Response update(@FormParam(value="token") String token, @FormParam(value="password") String password) throws SQLException {
        for (long userId : Context.getUsersManager().getAllItems()) {
            User user = (User)Context.getUsersManager().getById(userId);
            if (!token.equals(user.getString(PASSWORD_RESET_TOKEN))) continue;
            user.getAttributes().remove(PASSWORD_RESET_TOKEN);
            user.setPassword(password);
            Context.getUsersManager().updateItem(user);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

