/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.init;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.init.InitProjectUtil;
import com.datical.liquibase.ext.init.InteractivePromptingValueProvider;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.core.DefaultsFileValueProvider;
import liquibase.exception.CommandExecutionException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;

public class InitProjectCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"init", "project"};
    public static final CommandArgumentDefinition<String> INIT_PROJECT_DIR_ARG;
    public static final CommandArgumentDefinition<String> INIT_FORMAT_ARG;
    public static final CommandArgumentDefinition<String> INIT_CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> INIT_DEFAULTS_FILE_ARG;
    public static final CommandArgumentDefinition<String> INIT_PROJECT_GUIDE_ARG;
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;

    private boolean isProjectGuideOn(String string) {
        return string.equalsIgnoreCase("on");
    }

    private void doPrompt(ConfiguredValue<String> configuredValue, CommandArgumentDefinition<String> commandArgumentDefinition, CommandScope commandScope, DynamicRuleParameterEnum dynamicRuleParameterEnum, InteractivePromptingValueProvider interactivePromptingValueProvider) {
        this.doPrompt(configuredValue, commandArgumentDefinition, commandScope, dynamicRuleParameterEnum, interactivePromptingValueProvider, null);
    }

    private void doPrompt(ConfiguredValue<String> configuredValue, CommandArgumentDefinition<String> commandArgumentDefinition, CommandScope commandScope, DynamicRuleParameterEnum dynamicRuleParameterEnum, InteractivePromptingValueProvider interactivePromptingValueProvider, Object object) {
        if (configuredValue.wasDefaultValueUsed()) {
            dynamicRuleParameterEnum = dynamicRuleParameterEnum.interactiveCommandLineValueGetter.prompt(new RuleParameter(dynamicRuleParameterEnum), null, object);
            if (!configuredValue.getValue().equals((Object)dynamicRuleParameterEnum)) {
                interactivePromptingValueProvider.addValue(commandScope.getCompleteConfigPrefix() + "." + commandArgumentDefinition.getName(), (Object)dynamicRuleParameterEnum);
            }
        }
    }

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        Object object = commandResultsBuilder.getCommandScope().getConfiguredValue(INIT_PROJECT_GUIDE_ARG);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (!((ConfiguredValue)object).wasDefaultValueUsed() && this.isProjectGuideOn((String)(object = ((ConfiguredValue)object).getValue()))) {
            hashMap.put(GlobalConfiguration.HEADLESS.getKey(), Boolean.FALSE);
        }
        try {
            object = Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
            ((LiquibaseConfiguration)object).getProviders().stream().filter(configurationValueProvider -> configurationValueProvider instanceof DefaultsFileValueProvider).findFirst().ifPresent(((LiquibaseConfiguration)object)::unregisterProvider);
            Scope.child(hashMap, () -> this.internalRun(commandResultsBuilder));
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void internalRun(CommandResultsBuilder commandResultsBuilder) {
        String string2;
        Object object2;
        Object object3 = commandResultsBuilder.getCommandScope();
        ConfiguredValue<String> configuredValue = ((CommandScope)object3).getConfiguredValue(INIT_DEFAULTS_FILE_ARG);
        ConfiguredValue<String> configuredValue2 = ((CommandScope)object3).getConfiguredValue(INIT_FORMAT_ARG);
        ConfiguredValue<String> configuredValue3 = ((CommandScope)object3).getConfiguredValue(INIT_CHANGELOG_FILE_ARG);
        ConfiguredValue<String> configuredValue4 = ((CommandScope)object3).getConfiguredValue(INIT_PROJECT_DIR_ARG);
        ConfiguredValue<String> configuredValue5 = ((CommandScope)object3).getConfiguredValue(URL_ARG);
        ConfiguredValue<String> configuredValue6 = ((CommandScope)object3).getConfiguredValue(USERNAME_ARG);
        ConfiguredValue<String> configuredValue7 = ((CommandScope)object3).getConfiguredValue(PASSWORD_ARG);
        String string3 = ((CommandScope)object3).getConfiguredValue(INIT_PROJECT_GUIDE_ARG).getValue();
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.isProjectGuideOn(string3) && (configuredValue4.wasDefaultValueUsed() || configuredValue3.wasDefaultValueUsed() || configuredValue2.wasDefaultValueUsed() || configuredValue.wasDefaultValueUsed() || configuredValue5.wasDefaultValueUsed() || configuredValue6.wasDefaultValueUsed() || configuredValue7.wasDefaultValueUsed())) {
            string3 = Scope.getCurrentScope().getUI().prompt("Setup new liquibase.properties and sample changelog? Enter (Y)es with defaults, yes with (C)ustomization, or (N)o.", "Y", (string, object) -> {
                object = Arrays.asList("y", "yes", "n", "no", "c", "custom", "customize");
                if (string == null || object.stream().noneMatch(string2 -> string2.equalsIgnoreCase(string))) {
                    throw new IllegalArgumentException();
                }
                return string;
            }, String.class);
            if (string3.toLowerCase().startsWith("c")) {
                object2 = new InteractivePromptingValueProvider();
                Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class).registerProvider((ConfigurationValueProvider)object2);
                this.doPrompt(configuredValue4, INIT_PROJECT_DIR_ARG, (CommandScope)object3, DynamicRuleParameterEnum.PROJECT_DIR, (InteractivePromptingValueProvider)object2);
                configuredValue4 = ((CommandScope)object3).getConfiguredValue(INIT_PROJECT_DIR_ARG);
                String string4 = this.findLatestChangelogFilename(configuredValue4);
                this.doPrompt(configuredValue3, INIT_CHANGELOG_FILE_ARG, (CommandScope)object3, DynamicRuleParameterEnum.SAMPLE_CHANGELOG_NAME, (InteractivePromptingValueProvider)object2, string4);
                configuredValue3 = ((CommandScope)object3).getConfiguredValue(INIT_CHANGELOG_FILE_ARG);
                bl2 = this.isSkipped(configuredValue3);
                if (bl2) {
                    Scope.getCurrentScope().getUI().sendMessage("No changelog file will be created. Specify a valid changelog file on the CLI, via Environment variable, or in your defaults file. Learn more at Getting Started <url>");
                } else if (InitProjectUtil.determineFormatType(configuredValue3.getValue(), null) == null) {
                    this.doPrompt(configuredValue2, INIT_FORMAT_ARG, (CommandScope)object3, DynamicRuleParameterEnum.FILETYPE, (InteractivePromptingValueProvider)object2);
                }
                this.doPrompt(configuredValue, INIT_DEFAULTS_FILE_ARG, (CommandScope)object3, DynamicRuleParameterEnum.DEFAULTS_FILENAME, (InteractivePromptingValueProvider)object2);
                configuredValue = ((CommandScope)object3).getConfiguredValue(INIT_DEFAULTS_FILE_ARG);
                bl3 = this.isSkipped(configuredValue);
                if (bl3) {
                    Scope.getCurrentScope().getUI().sendMessage("No defaults file will be created. Specify a valid defaults file on the CLI, via Environment variable, or pass all required properties on the CLI, via Environment variables. Learn more at Getting Started <url>");
                } else {
                    this.doPrompt(configuredValue5, URL_ARG, (CommandScope)object3, DynamicRuleParameterEnum.JDBC_URL, (InteractivePromptingValueProvider)object2);
                    this.doPrompt(configuredValue6, USERNAME_ARG, (CommandScope)object3, DynamicRuleParameterEnum.USERNAME, (InteractivePromptingValueProvider)object2);
                    this.doPrompt(configuredValue7, PASSWORD_ARG, (CommandScope)object3, DynamicRuleParameterEnum.PASSWORD, (InteractivePromptingValueProvider)object2);
                }
                configuredValue2 = ((CommandScope)object3).getConfiguredValue(INIT_FORMAT_ARG);
                configuredValue5 = ((CommandScope)object3).getConfiguredValue(URL_ARG);
                configuredValue6 = ((CommandScope)object3).getConfiguredValue(USERNAME_ARG);
                configuredValue7 = ((CommandScope)object3).getConfiguredValue(PASSWORD_ARG);
                if (!bl2 || !bl3) {
                    string2 = String.format("Setting up new Liquibase project in '%s'...", new File(configuredValue4.getValue()).getAbsolutePath());
                    Scope.getCurrentScope().getLog(this.getClass()).info(string2);
                    Scope.getCurrentScope().getUI().sendMessage(string2);
                }
            } else if (string3.toLowerCase().startsWith("y")) {
                object2 = String.format("Setting up new Liquibase project in '%s'...", new File(configuredValue4.getValue()).getAbsolutePath());
                Scope.getCurrentScope().getLog(this.getClass()).info((String)object2);
                Scope.getCurrentScope().getUI().sendMessage((String)object2);
            } else if (string3.toLowerCase().startsWith("n")) {
                String string5 = "No files created. Set 'liquibase.init.project.guide=off' in your defaults file or set LIQUIBASE_COMMAND_INIT_PROJECT_PROJECT_GUIDE=off as an environment variable to not be asked again. Getting Started and project setup available anytime, run \"liquibase init project --help\" for information.";
                Scope.getCurrentScope().getLog(this.getClass()).info(string5);
                Scope.getCurrentScope().getUI().sendMessage(string5);
                return;
            }
        }
        string3 = configuredValue4.getValue();
        object2 = new File(string3);
        InitProjectUtil.validateProjectDirectory((File)object2);
        InitProjectUtil.createProjectDirectory((File)object2);
        if (!bl2 || !bl3) {
            boolean bl4 = false;
            string2 = null;
            if (!bl2) {
                String string6 = configuredValue3.getValue();
                InitProjectUtil.validateChangelogFilePath(string6);
                if (configuredValue2.wasDefaultValueUsed() && (string2 = InitProjectUtil.determineFormatType(string6, configuredValue2.getValue())) == null) {
                    object3 = "Unable to determine format for the changelog file '" + string6 + "'";
                    throw new CommandExecutionException((String)object3);
                }
                if (string2 == null) {
                    string2 = ((CommandScope)object3).getConfiguredValue(INIT_FORMAT_ARG).getValue();
                }
                if (InitProjectUtil.getExtension(string6) == null) {
                    string6 = string6 + "." + string2;
                }
                bl4 = InitProjectUtil.copyExampleChangelog(string2, (File)object2, string6, configuredValue3);
            }
            if (!bl3) {
                boolean bl5 = false;
                object3 = new File((File)object2, configuredValue.getValue());
                if (!((File)object3).exists()) {
                    if (!bl4) {
                        Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator());
                    }
                    object3 = InitProjectUtil.copyExampleProperties(string2, string3, configuredValue.getValue());
                    bl5 = true;
                }
                InitProjectUtil.updateDefaultsFile((File)object3, bl5, string2, configuredValue3, configuredValue5, configuredValue6, configuredValue7, bl4);
            }
            String string7 = "To use the new project files";
            if (!configuredValue4.wasDefaultValueUsed()) {
                string7 = string7 + String.format(", please cd into '%s',", string3);
            }
            string7 = string7 + " make sure your database is active and accessible";
            string7 = configuredValue5.wasDefaultValueUsed() && configuredValue6.wasDefaultValueUsed() && configuredValue7.wasDefaultValueUsed() ? string7 + " by opening a new terminal window to run \"liquibase init start-h2\", and then return to this terminal window to run \"liquibase update\" command." : string7 + " and run \"liquibase update\".";
            string7 = string7 + " For more details, visit the Getting Started Guide at https://www.liquibase.org/get-started/quickstart";
            Scope.getCurrentScope().getLog(this.getClass()).info(string7);
            Scope.getCurrentScope().getUI().sendMessage(string7);
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    private boolean isSkipped(ConfiguredValue<String> configuredValue) {
        return configuredValue.getValue().equalsIgnoreCase("s");
    }

    private String findLatestChangelogFilename(ConfiguredValue<String> fileArray) {
        try {
            fileArray = InitProjectUtil.findChangeLogsInProjectDir(new File(fileArray.getValue()));
            if (fileArray != null && fileArray.length > 0) {
                Arrays.sort(fileArray, (file, file2) -> Long.compare(file2.lastModified(), file.lastModified()));
                return fileArray[0].getName();
            }
        }
        catch (Exception exception) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Failed to find an existing changelog file in the specified project directory, using default instead", exception);
        }
        return null;
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Creates the directory and files needed to run Liquibase commands. Run without any flags on the CLI, or set via Environment variable, etc will launch an interactive guide to walk users through setting up the necessary project's default and changelog files. This guide can be turned off by setting the 'liquibase.init.project.guide=off'");
        commandDefinition.setGroupShortDescription(new String[]{"init"}, "Init commands");
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        INIT_PROJECT_DIR_ARG = commandBuilder.argument("projectDir", String.class).description("Relative or fully qualified path to the directory where the project files will be created").defaultValue((String)DynamicRuleParameterEnum.PROJECT_DIR.defaultValue).build();
        INIT_FORMAT_ARG = commandBuilder.argument("format", String.class).description("Format of the project changelog sql|xml|json|yaml|yml").defaultValue(DynamicRuleParameterEnum.FILETYPE.defaultValue.toString()).build();
        INIT_DEFAULTS_FILE_ARG = commandBuilder.argument("projectDefaultsFile", String.class).description(LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getDescription()).defaultValue(LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getDefaultValue()).build();
        INIT_PROJECT_GUIDE_ARG = commandBuilder.argument("projectGuide", String.class).description("Allow interactive prompts for init project").defaultValue("on").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (!((String)(object = String.valueOf(object))).equalsIgnoreCase("on") && !((String)object).equalsIgnoreCase("off")) {
                object = "\nWARNING: The projectGuide parameter must be set to either 'on' or 'off'.  (Blank defaults to 'on')";
                throw new IllegalArgumentException((String)object);
            }
            return object;
        }).build();
        INIT_CHANGELOG_FILE_ARG = commandBuilder.argument("changelogFile", String.class).description("Relative or fully qualified path to the changelog file").defaultValue((String)DynamicRuleParameterEnum.SAMPLE_CHANGELOG_NAME.defaultValue).build();
        URL_ARG = commandBuilder.argument("url", String.class).description("The JDBC database connection URL").defaultValue((String)DynamicRuleParameterEnum.JDBC_URL.defaultValue).build();
        USERNAME_ARG = commandBuilder.argument("username", String.class).description("Username to use to connect to the database").defaultValue((String)DynamicRuleParameterEnum.USERNAME.defaultValue).build();
        PASSWORD_ARG = commandBuilder.argument("password", String.class).description("Password to use to connect to the database").defaultValue((String)DynamicRuleParameterEnum.PASSWORD.defaultValue).setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
    }
}

