/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog.core;

import liquibase.change.Change;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.AbstractChangeGenerator;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import liquibase.util.StringUtil;

public class MissingForeignKeyChangeGenerator
extends AbstractChangeGenerator
implements MissingObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (ForeignKey.class.isAssignableFrom(objectType)) {
            return 1;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Table.class, Column.class, PrimaryKey.class, UniqueConstraint.class, Index.class};
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    @Override
    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        ForeignKey fk2 = (ForeignKey)missingObject;
        AddForeignKeyConstraintChange change = new AddForeignKeyConstraintChange();
        change.setConstraintName(fk2.getName());
        String defaultSchemaName = StringUtil.trimToEmpty(referenceDatabase.getDefaultSchemaName());
        String defaultCatalogName = StringUtil.trimToEmpty(referenceDatabase.getDefaultCatalogName());
        String compDefaultSchemaName = StringUtil.trimToEmpty(comparisonDatabase.getDefaultSchemaName());
        String compDefaultCatalogName = StringUtil.trimToEmpty(comparisonDatabase.getDefaultCatalogName());
        boolean includedCatalog = false;
        change.setReferencedTableName(fk2.getPrimaryKeyTable().getName());
        String missingPrimaryKeyCatalogName = StringUtil.trimToEmpty(fk2.getPrimaryKeyTable().getSchema().getCatalogName());
        if (referenceDatabase.supportsCatalogs()) {
            if (control.getIncludeCatalog() || control.considerCatalogsAsSchemas()) {
                change.setReferencedTableCatalogName(fk2.getPrimaryKeyTable().getSchema().getCatalogName());
                includedCatalog = true;
            } else if (!defaultCatalogName.equalsIgnoreCase(missingPrimaryKeyCatalogName) && !compDefaultCatalogName.equalsIgnoreCase(missingPrimaryKeyCatalogName)) {
                change.setReferencedTableCatalogName(fk2.getPrimaryKeyTable().getSchema().getCatalogName());
                includedCatalog = true;
            }
        }
        String missingPrimaryKeySchemaName = StringUtil.trimToEmpty(fk2.getPrimaryKeyTable().getSchema().getName());
        if (referenceDatabase.supportsSchemas()) {
            if (includedCatalog || control.getIncludeSchema()) {
                change.setReferencedTableSchemaName(fk2.getPrimaryKeyTable().getSchema().getName());
            } else if (!defaultSchemaName.equalsIgnoreCase(missingPrimaryKeySchemaName) && !compDefaultSchemaName.equalsIgnoreCase(missingPrimaryKeySchemaName)) {
                change.setReferencedTableSchemaName(fk2.getPrimaryKeyTable().getSchema().getName());
            }
        }
        change.setReferencedColumnNames(StringUtil.join(fk2.getPrimaryKeyColumns(), ",", (StringUtil.StringUtilFormatter)new StringUtil.StringUtilFormatter<Column>(){

            @Override
            public String toString(Column obj) {
                return obj.getName();
            }
        }));
        change.setBaseTableName(fk2.getForeignKeyTable().getName());
        if (control.getIncludeCatalog()) {
            change.setBaseTableCatalogName(fk2.getForeignKeyTable().getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            change.setBaseTableSchemaName(fk2.getForeignKeyTable().getSchema().getName());
        }
        change.setBaseColumnNames(StringUtil.join(fk2.getForeignKeyColumns(), ",", (StringUtil.StringUtilFormatter)new StringUtil.StringUtilFormatter<Column>(){

            @Override
            public String toString(Column obj) {
                return obj.getName();
            }
        }));
        change.setDeferrable(fk2.isDeferrable());
        change.setInitiallyDeferred(fk2.isInitiallyDeferred());
        change.setValidate(fk2.shouldValidate());
        change.setOnUpdate(fk2.getUpdateRule());
        change.setOnDelete(fk2.getDeleteRule());
        Index backingIndex = fk2.getBackingIndex();
        if (referenceDatabase.createsIndexesForForeignKeys()) {
            control.setAlreadyHandledMissing(backingIndex);
        }
        return new Change[]{change};
    }
}

