/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class WindowsMenuBarUI
extends com.sun.java.swing.plaf.windows.WindowsMenuBarUI {
    public static ComponentUI createUI(JComponent x) {
        return new WindowsMenuBarUI();
    }

    protected void installDefaults() {
        if (this.menuBar.getLayout() == null || this.menuBar.getLayout() instanceof UIResource) {
            this.menuBar.setLayout(new MenuLayout());
        }
        super.installDefaults();
    }

    class MenuLayout
    extends FlowLayout {
        int hgap = 0;
        int vgap = 0;

        public MenuLayout() {
            super(0, 0, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Dimension dim = new Dimension(0, 0);
                int nmembers = target.getComponentCount();
                boolean firstVisibleComponent = true;
                int parentWidth = target.getParent().getSize().width;
                int remain = 0;
                int maxHeightInRow = 0;
                for (int i = 0; i < nmembers; ++i) {
                    Component m = target.getComponent(i);
                    if (!m.isVisible()) continue;
                    Dimension d = m.getPreferredSize();
                    if (firstVisibleComponent) {
                        firstVisibleComponent = false;
                    } else {
                        dim.width += this.hgap;
                    }
                    dim.width += d.width;
                    if (remain < d.width) {
                        dim.height += maxHeightInRow;
                        maxHeightInRow = d.height;
                        if (d.width > parentWidth) {
                            remain = 0;
                            continue;
                        }
                        remain = parentWidth - d.width;
                        continue;
                    }
                    remain -= d.width;
                    maxHeightInRow = Math.max(d.height, maxHeightInRow);
                }
                dim.height += maxHeightInRow;
                Insets insets = target.getInsets();
                dim.width += insets.left + insets.right;
                dim.height += insets.top + insets.bottom;
                return dim;
            }
        }

        public void layoutContainer(Container target) {
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            if (ltr) {
                this.setAlignment(0);
            } else {
                this.setAlignment(2);
            }
            super.layoutContainer(target);
        }
    }
}

