/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.resources.AudioResource;
import net.sf.freecol.common.resources.ColorResource;
import net.sf.freecol.common.resources.FAFile;
import net.sf.freecol.common.resources.FAFileResource;
import net.sf.freecol.common.resources.FontResource;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.ResourceMapping;
import net.sf.freecol.common.resources.SZAResource;
import net.sf.freecol.common.resources.StringResource;
import net.sf.freecol.common.resources.Video;
import net.sf.freecol.common.resources.VideoResource;

public class ResourceManager {
    private static final Logger logger = Logger.getLogger(ResourceManager.class.getName());
    public static final String REPLACEMENT_IMAGE = "image.miscicon.delete";
    public static final String REPLACEMENT_STRING = "X";
    private static ResourceMapping baseMapping;
    private static ResourceMapping tcMapping;
    private static ResourceMapping scenarioMapping;
    private static ResourceMapping modMapping;
    private static ResourceMapping mergedContainer;
    private static volatile Thread preloadThread;

    public static synchronized void setBaseMapping(ResourceMapping mapping) {
        logger.info("setBaseMapping " + mapping);
        baseMapping = mapping;
        ResourceManager.update(mapping != null);
    }

    public static synchronized void setTcMapping(ResourceMapping mapping) {
        logger.info("setTcMapping " + mapping);
        tcMapping = mapping;
        ResourceManager.update(mapping != null);
    }

    public static synchronized void setModMapping(ResourceMapping mapping) {
        logger.info("setModMapping " + mapping);
        modMapping = mapping;
        ResourceManager.update(mapping != null);
    }

    public static synchronized void setScenarioMapping(ResourceMapping mapping) {
        logger.info("setScenarioMapping " + mapping);
        scenarioMapping = mapping;
        ResourceManager.clean();
        ResourceManager.update(mapping != null);
    }

    public static synchronized void clean() {
        ImageResource resource;
        if (baseMapping != null) {
            for (Map.Entry<String, ImageResource> entry : baseMapping.getImageResources().entrySet()) {
                resource = entry.getValue();
                resource.clean();
            }
        }
        if (tcMapping != null) {
            for (Map.Entry<String, ImageResource> entry : tcMapping.getImageResources().entrySet()) {
                resource = entry.getValue();
                resource.clean();
            }
        }
        if (scenarioMapping != null) {
            for (Map.Entry<String, ImageResource> entry : scenarioMapping.getImageResources().entrySet()) {
                resource = entry.getValue();
                resource.clean();
            }
        }
        if (modMapping != null) {
            for (Map.Entry<String, ImageResource> entry : modMapping.getImageResources().entrySet()) {
                resource = entry.getValue();
                resource.clean();
            }
        }
        System.gc();
    }

    private static void update(boolean newItems) {
        logger.finest("update(" + newItems + ")");
        if (newItems) {
            preloadThread = null;
        }
        ResourceManager.createMergedContainer();
        if (newItems) {
            ResourceManager.startBackgroundPreloading();
        }
    }

    private static void createMergedContainer() {
        ResourceMapping mc = new ResourceMapping();
        mc.addAll(baseMapping);
        mc.addAll(tcMapping);
        mc.addAll(scenarioMapping);
        mc.addAll(modMapping);
        mergedContainer = mc;
    }

    private static void startBackgroundPreloading() {
        if ("true".equals(System.getProperty("java.awt.headless", "false"))) {
            return;
        }
        preloadThread = new Thread("FreeColClient:-Resource loader"){

            @Override
            public void run() {
                logger.info("Background thread started");
                ArrayList<Resource> resources = new ArrayList<Resource>(ResourceManager.getResources().values());
                int n = 0;
                for (Resource r : resources) {
                    if (preloadThread != this) {
                        logger.info("Background thread cancelled after it preloaded " + n + " resources.");
                        return;
                    }
                    if (!(r instanceof Resource.Preloadable)) continue;
                    ((Resource.Preloadable)((Object)r)).preload();
                    ++n;
                }
                logger.info("Background thread preloaded " + n + " resources.");
            }
        };
        preloadThread.setPriority(2);
        preloadThread.start();
    }

    public static synchronized boolean hasResource(String key) {
        logger.finest("hasResource(" + key + ")");
        return mergedContainer.containsKey(key);
    }

    public static synchronized boolean hasImageResource(String key) {
        return mergedContainer.containsImageKey(key);
    }

    public static synchronized boolean hasColorResource(String key) {
        return mergedContainer.containsColorKey(key);
    }

    public static synchronized Map<String, Resource> getResources() {
        logger.finest("getResources");
        return mergedContainer.getResources();
    }

    public static synchronized Map<String, ImageResource> getImageResources() {
        logger.finest("getImageResources");
        return mergedContainer.getImageResources();
    }

    public static synchronized List<String> getImageKeys(String prefix) {
        return mergedContainer.getImageKeys(prefix);
    }

    public static synchronized List<String> getImageKeys(String prefix, String suffix) {
        logger.finest("getImageKeys(" + prefix + ", " + suffix + ")");
        return mergedContainer.getImageKeys(prefix, suffix);
    }

    public static synchronized Set<String> getImageKeySet(String prefix) {
        return mergedContainer.getImageKeySet(prefix);
    }

    private static synchronized ColorResource getColorResource(String key) {
        ColorResource r = mergedContainer.getColorResource(key);
        if (r == null) {
            logger.warning("getColorResource(" + key + ") failed");
        }
        return r;
    }

    private static synchronized FontResource getFontResource(String key) {
        FontResource r = mergedContainer.getFontResource(key);
        if (r == null) {
            logger.warning("getFontResource(" + key + ") failed");
        }
        return r;
    }

    private static synchronized StringResource getStringResource(String key) {
        StringResource r = mergedContainer.getStringResource(key);
        if (r == null) {
            logger.warning("getStringResource(" + key + ") failed");
        }
        return r;
    }

    private static synchronized FAFileResource getFAFileResource(String key) {
        FAFileResource r = mergedContainer.getFAFileResource(key);
        if (r == null) {
            logger.warning("getFAFileResource(" + key + ") failed");
        }
        return r;
    }

    private static synchronized SZAResource getSZAResource(String key) {
        SZAResource r = mergedContainer.getSZAResource(key);
        if (r == null) {
            logger.warning("getSZAResource(" + key + ") failed");
        }
        return r;
    }

    private static synchronized AudioResource getAudioResource(String key) {
        AudioResource r = mergedContainer.getAudioResource(key);
        if (r == null) {
            logger.warning("getAudioResource(" + key + ") failed");
        }
        return r;
    }

    private static synchronized VideoResource getVideoResource(String key) {
        VideoResource r = mergedContainer.getVideoResource(key);
        if (r == null) {
            logger.warning("getVideoResource(" + key + ") failed");
        }
        return r;
    }

    private static synchronized ImageResource getImageResource(String key) {
        ImageResource r = mergedContainer.getImageResource(key);
        if (r == null) {
            logger.warning("getImageResource(" + key + ") failed");
            r = mergedContainer.getImageResource(REPLACEMENT_IMAGE);
            if (r == null) {
                FreeColClient.fatal("Failed getting replacement image.");
            }
        }
        return r;
    }

    public static BufferedImage getImage(String key) {
        BufferedImage image = ResourceManager.getImageResource(key).getImage();
        if (image == null) {
            logger.warning("getImage(" + key + ") failed");
            image = ResourceManager.getImageResource(REPLACEMENT_IMAGE).getImage();
            if (image == null) {
                FreeColClient.fatal("Failed getting replacement image.");
            }
        }
        return image;
    }

    public static BufferedImage getImage(String key, float scale) {
        BufferedImage image = ResourceManager.getImageResource(key).getImage(scale);
        if (image == null) {
            logger.warning("getImage(" + key + ", " + scale + ") failed");
            image = ResourceManager.getImageResource(REPLACEMENT_IMAGE).getImage(scale);
            if (image == null) {
                FreeColClient.fatal("Failed getting replacement image.");
            }
        }
        return image;
    }

    public static BufferedImage getImage(String key, Dimension size) {
        BufferedImage image = ResourceManager.getImageResource(key).getImage(size);
        if (image == null) {
            logger.warning("getImage(" + key + ", " + size + ") failed");
            image = ResourceManager.getImageResource(REPLACEMENT_IMAGE).getImage(size);
            if (image == null) {
                FreeColClient.fatal("Failed getting replacement image.");
            }
        }
        return image;
    }

    public static BufferedImage getGrayscaleImage(String key, Dimension size) {
        BufferedImage image = ResourceManager.getImageResource(key).getGrayscaleImage(size);
        if (image == null) {
            logger.warning("getGrayscaleImage(" + key + ", " + size + ") failed");
            image = ResourceManager.getImageResource(REPLACEMENT_IMAGE).getGrayscaleImage(size);
            if (image == null) {
                FreeColClient.fatal("Failed getting replacement image.");
            }
        }
        return image;
    }

    public static BufferedImage getGrayscaleImage(String key, float scale) {
        BufferedImage image = ResourceManager.getImageResource(key).getGrayscaleImage(scale);
        if (image == null) {
            logger.warning("getGrayscaleImage(" + key + ", " + scale + ") failed");
            image = ResourceManager.getImageResource(REPLACEMENT_IMAGE).getGrayscaleImage(scale);
            if (image == null) {
                FreeColClient.fatal("Failed getting replacement image.");
            }
        }
        return image;
    }

    public static SimpleZippedAnimation getSimpleZippedAnimation(String key) {
        SZAResource r = ResourceManager.getSZAResource(key);
        return r != null ? r.getSimpleZippedAnimation() : null;
    }

    public static SimpleZippedAnimation getSimpleZippedAnimation(String key, float scale) {
        SZAResource r = ResourceManager.getSZAResource(key);
        return r != null ? r.getSimpleZippedAnimation(scale) : null;
    }

    public static Color getColor(String key) {
        ColorResource r = ResourceManager.getColorResource(key);
        return r == null ? ColorResource.REPLACEMENT_COLOR : r.getColor();
    }

    public static Font getFont(String key) {
        FontResource r = ResourceManager.getFontResource(key);
        if (r == null) {
            return FontResource.getEmergencyFont();
        }
        return r.getFont();
    }

    public static File getAudio(String key) {
        AudioResource r = ResourceManager.getAudioResource(key);
        return r == null ? null : r.getAudio();
    }

    public static Video getVideo(String key) {
        VideoResource r = ResourceManager.getVideoResource(key);
        return r != null ? r.getVideo() : null;
    }

    public static FAFile getFAFile(String key) {
        FAFileResource r = ResourceManager.getFAFileResource(key);
        return r == null ? null : r.getFAFile();
    }

    public static String getString(String key) {
        StringResource r = ResourceManager.getStringResource(key);
        return r == null ? REPLACEMENT_STRING : r.getString();
    }

    static {
        preloadThread = null;
    }
}

