/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.server.ai.AIMain;
import org.w3c.dom.Element;

public abstract class AIObject
extends FreeColObject {
    private static final Logger logger = Logger.getLogger(FreeColObject.class.getName());
    private final AIMain aiMain;
    protected boolean uninitialized = false;

    public AIObject(AIMain aiMain) {
        this.aiMain = aiMain;
        this.uninitialized = true;
    }

    public AIObject(AIMain aiMain, String id) {
        this(aiMain);
        if (id != null) {
            this.setId(id);
            aiMain.addAIObject(id, this);
        }
        this.uninitialized = true;
    }

    public AIObject(AIMain aiMain, Element element) {
        this(aiMain);
        this.readFromXMLElement(element);
        this.addAIObjectWithId();
    }

    public AIObject(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        this(aiMain);
        this.readFromXML(xr);
        this.addAIObjectWithId();
    }

    public final AIMain getAIMain() {
        return this.aiMain;
    }

    public final Game getGame() {
        return this.aiMain.getGame();
    }

    public final boolean isUninitialized() {
        return this.uninitialized;
    }

    public void dispose() {
        this.getAIMain().removeAIObject(this.getId());
    }

    public final boolean isDisposed() {
        return this.getAIMain().getAIObject(this.getId()) == null;
    }

    protected final void addAIObjectWithId() {
        if (this.getId() != null) {
            this.aiMain.addAIObject(this.getId(), this);
        }
    }

    @Override
    public final Specification getSpecification() {
        return this.getGame().getSpecification();
    }

    public int checkIntegrity(boolean fix) {
        return this.isUninitialized() ? -1 : 1;
    }
}

