/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.StateFullPathCompleter;
import org.jboss.galleon.cli.cmd.state.StateInfoUtil;
import org.jboss.galleon.cli.model.FeatureContainer;

@CommandDefinition(name="ls", description="List the current node content")
public class StateLsCommand
extends PmSessionCommand {
    @Argument(completer=StateFullPathCompleter.class, description="Feature pack node path")
    private String path;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        if (this.path == null || this.path.isEmpty()) {
            this.path = session.getPmSession().getCurrentPath();
        }
        FeatureContainer container = session.getPmSession().getContainer();
        if (!this.path.startsWith("/")) {
            this.path = session.getPmSession().getCurrentPath() + this.path;
        }
        try {
            StateInfoUtil.printContentPath(session, container, this.path);
        }
        catch (Exception ex) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.displayContentFailed(), ex);
        }
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.EDITING;
    }
}

