/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin.util;

import java.io.File;
import java.nio.file.Path;
import org.apache.maven.shared.artifact.ArtifactCoordinate;

public class ResolveLocalItem
implements ArtifactCoordinate {
    private Path path;
    private String groupId;
    private String artifactId;
    private String version;
    private String extension = "zip";
    private String classifier = "";
    private Boolean installInUniverse;
    private String error;

    public void setPath(File file) {
        this.assertPath();
        this.path = file.toPath().normalize();
        this.installInUniverse = this.installInUniverse == null ? Boolean.TRUE : this.installInUniverse;
    }

    public Path getNormalizedPath() {
        return this.path;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.assertNotPath();
        this.groupId = groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.assertNotPath();
        this.artifactId = artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.assertNotPath();
        this.version = version;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.assertNotPath();
        this.extension = extension;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.assertNotPath();
        this.classifier = classifier;
    }

    public void setInstallInUniverse(Boolean installInUniverse) {
        this.assertInstallInUniverse();
        this.installInUniverse = installInUniverse;
    }

    public Boolean getInstallInUniverse() {
        return this.installInUniverse;
    }

    private void assertNotPath() {
        if (this.path != null || this.installInUniverse != null) {
            this.error = "feature-pack artifact cannot be used: feature-pack Path or install-in-universe have already been initialized";
            throw new IllegalStateException(this.error);
        }
    }

    public boolean hasArtifactCoords() {
        return this.groupId != null || this.artifactId != null || this.version != null;
    }

    private void assertPath() {
        if (this.hasArtifactCoords()) {
            this.error = "feature-pack Path cannot be used: feature-pack artifact has already been initialized";
            throw new IllegalStateException(this.error);
        }
    }

    private void assertInstallInUniverse() {
        if (this.hasArtifactCoords()) {
            this.error = "feature-pack install-in-universe cannot be used: feature-pack artifact has already been initialized";
            throw new IllegalStateException(this.error);
        }
    }

    public String getError() {
        return this.error;
    }
}

