/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.util.CollectionUtils;

public interface UniverseFeaturePackInstaller {
    public static Map<String, UniverseFeaturePackInstaller> load() throws ProvisioningException {
        ServiceLoader<UniverseFeaturePackInstaller> loader = ServiceLoader.load(UniverseFeaturePackInstaller.class);
        Map<Object, Object> universeInstallers = Collections.emptyMap();
        for (UniverseFeaturePackInstaller uCreator : loader) {
            if (universeInstallers.isEmpty()) {
                universeInstallers = Collections.singletonMap(uCreator.getUniverseFactoryId(), uCreator);
                continue;
            }
            if (universeInstallers.containsKey(uCreator.getUniverseFactoryId())) {
                throw new IllegalStateException("Only one universe feature-pack installer is allowed per repository type " + uCreator.getUniverseFactoryId() + " but found " + uCreator + " and " + universeInstallers.get(uCreator.getUniverseFactoryId()));
            }
            if (universeInstallers.size() == 1) {
                HashMap<Object, Object> tmp = new HashMap<Object, Object>(2);
                tmp.putAll(universeInstallers);
                universeInstallers = tmp;
            }
            universeInstallers.put(uCreator.getUniverseFactoryId(), uCreator);
        }
        return CollectionUtils.unmodifiable(universeInstallers);
    }

    public String getUniverseFactoryId();

    public void install(Universe<?> var1, FeaturePackLocation.FPID var2, Path var3) throws ProvisioningException;
}

