/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.state.ProvisionedState;
import org.jboss.galleon.xml.XmlParser;
import org.jboss.galleon.xml.XmlParsers;

public class ProvisionedStateXmlParser
implements XmlParser<ProvisionedState> {
    private static final ProvisionedStateXmlParser INSTANCE = new ProvisionedStateXmlParser();

    public static ProvisionedStateXmlParser getInstance() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProvisionedState parse(Path path) throws ProvisioningException {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            ProvisionedState provisionedState = ProvisionedStateXmlParser.getInstance().parse(reader);
            return provisionedState;
        }
        catch (IOException | XMLStreamException e) {
            throw new ProvisioningException(Errors.parseXml(path), e);
        }
    }

    private ProvisionedStateXmlParser() {
    }

    @Override
    public ProvisionedState parse(Reader input) throws XMLStreamException {
        ProvisionedState.Builder builder = ProvisionedState.builder();
        XmlParsers.parse(input, builder);
        return builder.build();
    }
}

