/*
 * Decompiled with CFR 0.152.
 */
package docking;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.image.BufferedImage;

public class HeaderCursor {
    static Cursor LEFT;
    static Cursor RIGHT;
    static Cursor TOP;
    static Cursor BOTTOM;
    static Cursor STACK;
    static Cursor NEW_WINDOW;
    static Cursor NO_DROP;

    private static Image drawLeftArrow() {
        int j;
        int i;
        BufferedImage image = new BufferedImage(32, 32, 2);
        int v = -16777216;
        int y = 6;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 2 * i + 1; ++j) {
                image.setRGB(i, y - i + j, v);
            }
        }
        for (i = 6; i < 12; ++i) {
            for (j = 0; j < 3; ++j) {
                image.setRGB(i, y - 1 + j, v);
            }
        }
        return image;
    }

    private static Image drawRightArrow() {
        int j;
        int i;
        BufferedImage image = new BufferedImage(32, 32, 2);
        int v = -16777216;
        int y = 6;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 2 * i + 1; ++j) {
                image.setRGB(31 - i, y - i + j, v);
            }
        }
        for (i = 6; i < 12; ++i) {
            for (j = 0; j < 3; ++j) {
                image.setRGB(31 - i, y - 1 + j, v);
            }
        }
        return image;
    }

    private static Image drawTopArrow() {
        int j;
        int i;
        BufferedImage image = new BufferedImage(32, 32, 2);
        int v = -16777216;
        int x = 6;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 2 * i + 1; ++j) {
                image.setRGB(x - i + j, i, v);
            }
        }
        for (i = 6; i < 12; ++i) {
            for (j = 0; j < 3; ++j) {
                image.setRGB(x - 1 + j, i, v);
            }
        }
        return image;
    }

    private static Image drawBottomArrow() {
        int j;
        int i;
        BufferedImage image = new BufferedImage(32, 32, 2);
        int v = -16777216;
        int x = 6;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 2 * i + 1; ++j) {
                image.setRGB(x - i + j, 31 - i, v);
            }
        }
        for (i = 6; i < 12; ++i) {
            for (j = 0; j < 3; ++j) {
                image.setRGB(x - 1 + j, 31 - i, v);
            }
        }
        return image;
    }

    private static Image drawStack() {
        BufferedImage image = new BufferedImage(32, 32, 2);
        int v = -16777216;
        for (int i = 0; i < 3; ++i) {
            int x = i * 3;
            int y = 6 - i * 3;
            for (int j = 0; j < 10; ++j) {
                image.setRGB(x, y + j, v);
                image.setRGB(x + 10, y + j, v);
                image.setRGB(x + j, y, v);
                image.setRGB(x + j, y + 10, v);
            }
        }
        return image;
    }

    private static Image drawNewWindow() {
        int i;
        BufferedImage image = new BufferedImage(32, 32, 2);
        int v = -16777216;
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 14; ++j) {
                image.setRGB(j, i, -16776961);
            }
        }
        for (i = 0; i < 14; ++i) {
            image.setRGB(i, 0, v);
            image.setRGB(i, 10, v);
        }
        for (i = 0; i < 10; ++i) {
            image.setRGB(0, i, v);
            image.setRGB(14, i, v);
        }
        return image;
    }

    static {
        NO_DROP = DragSource.DefaultMoveNoDrop;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image image = HeaderCursor.drawLeftArrow();
        LEFT = tk.createCustomCursor(image, new Point(0, 6), "LEFT");
        image = HeaderCursor.drawRightArrow();
        RIGHT = tk.createCustomCursor(image, new Point(31, 6), "RIGHT");
        image = HeaderCursor.drawTopArrow();
        TOP = tk.createCustomCursor(image, new Point(6, 0), "TOP");
        image = HeaderCursor.drawBottomArrow();
        BOTTOM = tk.createCustomCursor(image, new Point(6, 31), "BOTTOM");
        image = HeaderCursor.drawStack();
        STACK = tk.createCustomCursor(image, new Point(8, 8), "STACK");
        image = HeaderCursor.drawNewWindow();
        NEW_WINDOW = tk.createCustomCursor(image, new Point(0, 0), "NEW_WINDOW");
    }
}

