/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.indexedscrollpane;

import docking.widgets.indexedscrollpane.IndexedScrollable;
import docking.widgets.indexedscrollpane.ViewToIndexMapper;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DefaultViewToIndexMapper
implements ViewToIndexMapper {
    private static int MAX_SCROLL_VALUE = 0x3FFFFFFF;
    private static double AVERAGE_HEIGHT = 20.0;
    private BigInteger lastIndex;
    private BigInteger lastStartIndex;
    private double xFactor;
    private int screenHeight;
    private int viewHeight;
    private boolean endValidated;
    private final IndexedScrollable model;
    private int lastStartY = 0;

    public DefaultViewToIndexMapper(IndexedScrollable model, int screenHeight) {
        this.model = model;
        this.screenHeight = screenHeight;
        this.resetState();
    }

    private void resetState() {
        this.lastIndex = this.model.getIndexCount().subtract(BigInteger.ONE);
        double totalHeight = this.model.getIndexCount().doubleValue() * AVERAGE_HEIGHT;
        this.viewHeight = totalHeight > (double)MAX_SCROLL_VALUE ? MAX_SCROLL_VALUE : (int)totalHeight;
        this.xFactor = this.lastIndex.doubleValue() / (double)(this.viewHeight - this.screenHeight);
        this.lastStartIndex = this.lastIndex;
        this.lastStartY = 0;
        this.endValidated = false;
    }

    @Override
    public BigInteger getIndex(int value) {
        if (value == this.viewHeight - this.screenHeight) {
            return this.lastIndex;
        }
        double dindex = (double)value * this.xFactor;
        BigDecimal bindex = BigDecimal.valueOf(dindex);
        return bindex.toBigInteger();
    }

    @Override
    public int getVerticalOffset(int value) {
        return 0;
    }

    @Override
    public int getViewHeight() {
        return this.viewHeight;
    }

    @Override
    public void setVisibleViewHeight(int screenHeight) {
        this.screenHeight = screenHeight;
        this.resetState();
    }

    @Override
    public int getScrollValue(BigInteger startIndex, BigInteger endIndex, int startY, int endY) {
        if (!this.endValidated && endIndex.equals(this.lastIndex) && endY <= this.screenHeight) {
            this.lastStartIndex = startIndex;
            this.lastStartY = startY;
            this.xFactor = startIndex.doubleValue() / (double)(this.viewHeight - this.screenHeight);
            this.endValidated = true;
        }
        if (startIndex.equals(BigInteger.ZERO) && startY == 0) {
            return 0;
        }
        if (startIndex.equals(this.lastStartIndex) && startY == this.lastStartY) {
            return this.viewHeight - this.screenHeight;
        }
        double scrollValue = startIndex.doubleValue() / this.xFactor;
        int value = (int)(scrollValue + 0.5);
        if (value == 0) {
            return 1;
        }
        if (value >= this.viewHeight - this.screenHeight) {
            return this.viewHeight - this.screenHeight - 1;
        }
        return value;
    }

    @Override
    public void indexModelDataChanged(BigInteger start, BigInteger end) {
        if (end.compareTo(this.lastIndex) >= 0) {
            this.resetState();
        }
    }
}

