/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.TableFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CombinedTableFilter<T>
implements TableFilter<T> {
    private final List<TableFilter<T>> filters = new ArrayList<TableFilter<T>>();

    public CombinedTableFilter(TableFilter<T> filter1, TableFilter<T> filter2, TableFilter<T> filter3) {
        this.addIfNotNull(filter1);
        this.addIfNotNull(filter2);
        this.addIfNotNull(filter3);
    }

    private void addIfNotNull(TableFilter<T> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    @Override
    public boolean acceptsRow(T rowObject) {
        for (TableFilter<T> tableFilter : this.filters) {
            if (tableFilter.acceptsRow(rowObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public int getFilterCount() {
        return this.filters.size();
    }

    public TableFilter<?> getFilter(int index) {
        return this.filters.get(index);
    }

    @Override
    public boolean isSubFilterOf(TableFilter<?> tableFilter) {
        if (!(tableFilter instanceof CombinedTableFilter)) {
            return false;
        }
        CombinedTableFilter other = (CombinedTableFilter)tableFilter;
        if (this.getFilterCount() != other.getFilterCount()) {
            return false;
        }
        if (this.getFilterCount() == 0) {
            return false;
        }
        for (int i = 0; i < this.getFilterCount(); ++i) {
            if (this.getFilter(i).isSubFilterOf(other.getFilter(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasColumnFilter(int modelIndex) {
        for (TableFilter<T> tableFilter : this.filters) {
            if (!tableFilter.hasColumnFilter(modelIndex)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CombinedTableFilter other = (CombinedTableFilter)obj;
        return Objects.equals(this.filters, other.filters);
    }
}

