/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.sort;

import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableComparators;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.GColumnRenderer;
import java.util.Comparator;

public class ColumnRenderedValueBackupRowComparator<T>
implements Comparator<T> {
    protected int sortColumn;
    protected DynamicColumnTableModel<T> model;

    public ColumnRenderedValueBackupRowComparator(DynamicColumnTableModel<T> model, int sortColumn) {
        this.model = model;
        this.sortColumn = sortColumn;
    }

    @Override
    public int compare(T t1, T t2) {
        if (t1 == t2) {
            return 0;
        }
        String s1 = this.getRenderedColumnStringValue(t1);
        String s2 = this.getRenderedColumnStringValue(t2);
        if (s1 == null || s2 == null) {
            return TableComparators.compareWithNullValues(s1, s2);
        }
        return s1.compareToIgnoreCase(s2);
    }

    private String getRenderedColumnStringValue(T t) {
        DynamicTableColumn<T, ?, ?> column = this.model.getColumn(this.sortColumn);
        GColumnRenderer<?> renderer = column.getColumnRenderer();
        Object o = this.model.getColumnValueForRow(t, this.sortColumn);
        if (renderer == null) {
            return o == null ? null : o.toString();
        }
        Settings settings = this.model.getColumnSettings(this.sortColumn);
        return renderer.getFilterString(o, settings);
    }

    protected Object getColumnValue(T t) {
        return this.model.getColumnValueForRow(t, this.sortColumn);
    }
}

