/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.impliedmatches;

import ghidra.feature.vt.api.main.AssociationHook;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationMarkupStatus;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTControllerListener;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.options.Options;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.Collection;
import java.util.List;

public class MatchStatusUpdaterAssociationHook
implements AssociationHook,
VTControllerListener {
    private VTController controller;
    private VTSession session;

    public MatchStatusUpdaterAssociationHook(VTController controller) {
        this.controller = controller;
        this.setSession(controller.getSession());
        controller.addListener(this);
    }

    @Override
    public void associationAccepted(VTAssociation association) {
        this.updateMarkupStatus(association);
    }

    @Override
    public void associationCleared(VTAssociation association) {
        association.setMarkupStatus(new VTAssociationMarkupStatus());
    }

    @Override
    public void markupItemStatusChanged(VTMarkupItem markupItem) {
        this.controller.markupItemStatusChanged(markupItem);
        this.updateMarkupStatus(markupItem.getAssociation());
    }

    @Override
    public void sessionChanged(VTSession newSession) {
        this.setSession(newSession);
    }

    private void setSession(VTSession session) {
        if (this.session != null) {
            this.session.removeAssociationHook(this);
        }
        this.session = session;
        if (this.session != null) {
            this.session.addAssociationHook(this);
        }
    }

    private void updateMarkupStatus(VTAssociation association) {
        List<VTMatch> matches = association.getSession().getMatches(association);
        if (matches.isEmpty()) {
            return;
        }
        try {
            Collection<VTMarkupItem> markupItems = matches.get(0).getAssociation().getMarkupItems(TaskMonitorAdapter.DUMMY_MONITOR);
            VTAssociationMarkupStatus markupItemsStatus = this.getAppliedMarkupStatus(markupItems);
            association.setMarkupStatus(markupItemsStatus);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private VTAssociationMarkupStatus getAppliedMarkupStatus(Collection<VTMarkupItem> markupItems) {
        int appliedCount = 0;
        int rejectedCount = 0;
        int unappliedCount = 0;
        int dontKnowCount = 0;
        int dontCareCount = 0;
        int errorCount = 0;
        if (markupItems != null) {
            for (VTMarkupItem markupItem : markupItems) {
                VTMarkupItemStatus status = markupItem.getStatus();
                switch (status) {
                    case ADDED: 
                    case REPLACED: {
                        ++appliedCount;
                        break;
                    }
                    case FAILED_APPLY: {
                        ++errorCount;
                        break;
                    }
                    case DONT_KNOW: {
                        ++dontKnowCount;
                        break;
                    }
                    case REJECTED: {
                        ++rejectedCount;
                        break;
                    }
                    case UNAPPLIED: {
                        ++unappliedCount;
                        break;
                    }
                    case DONT_CARE: {
                        ++dontCareCount;
                        break;
                    }
                    case SAME: {
                        break;
                    }
                }
            }
        }
        return new VTAssociationMarkupStatus(unappliedCount > 0, appliedCount > 0, rejectedCount > 0, dontCareCount > 0, dontKnowCount > 0, errorCount > 0);
    }

    @Override
    public void disposed() {
    }

    @Override
    public void markupItemSelected(VTMarkupItem markupItem) {
    }

    @Override
    public void matchSelected(MatchInfo matchInfo) {
    }

    @Override
    public void optionsChanged(Options options) {
    }

    @Override
    public void sessionUpdated(DomainObjectChangedEvent ev) {
    }
}

