/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.wizard.AbstractMageJPanel;
import docking.wizard.WizardPanelDisplayability;
import docking.wizard.WizardState;
import ghidra.feature.vt.gui.wizard.AddressSetPanel;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.awt.GridLayout;

public class LimitAddressSetsPanel
extends AbstractMageJPanel<VTWizardStateKey> {
    private AddressSetPanel sourcePanel;
    private AddressSetPanel destinationPanel;

    public LimitAddressSetsPanel(PluginTool tool) {
        this.setLayout(new GridLayout());
        this.sourcePanel = new AddressSetPanel(tool, "Source", VTWizardStateKey.SOURCE_PROGRAM_FILE, VTWizardStateKey.SOURCE_PROGRAM, VTWizardStateKey.SOURCE_ADDRESS_SET_VIEW, VTWizardStateKey.SOURCE_SELECTION, VTWizardStateKey.SOURCE_ADDRESS_SET_CHOICE);
        this.destinationPanel = new AddressSetPanel(tool, "Destination", VTWizardStateKey.DESTINATION_PROGRAM_FILE, VTWizardStateKey.DESTINATION_PROGRAM, VTWizardStateKey.DESTINATION_ADDRESS_SET_VIEW, VTWizardStateKey.DESTINATION_SELECTION, VTWizardStateKey.DESTINATION_ADDRESS_SET_CHOICE);
        this.add((Component)((Object)this.sourcePanel));
        this.add((Component)((Object)this.destinationPanel));
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("VersionTrackingPlugin", "Select_Address_Ranges_Panel");
    }

    public void addDependencies(WizardState<VTWizardStateKey> state) {
        this.sourcePanel.addDependencies(state);
        this.destinationPanel.addDependencies(state);
    }

    public void dispose() {
        this.sourcePanel.dispose();
        this.destinationPanel.dispose();
    }

    public void enterPanel(WizardState<VTWizardStateKey> state) {
        this.sourcePanel.enterPanel(state);
        this.destinationPanel.enterPanel(state);
    }

    public WizardPanelDisplayability getPanelDisplayabilityAndUpdateState(WizardState<VTWizardStateKey> state) {
        WizardPanelDisplayability sourceDisplayability = this.sourcePanel.getPanelDisplayabilityAndUpdateState(state);
        this.destinationPanel.getPanelDisplayabilityAndUpdateState(state);
        return sourceDisplayability;
    }

    public void leavePanel(WizardState<VTWizardStateKey> state) {
        this.sourcePanel.leavePanel(state);
        this.destinationPanel.leavePanel(state);
    }

    public void updateStateObjectWithPanelInfo(WizardState<VTWizardStateKey> state) {
        this.sourcePanel.updateStateObjectWithPanelInfo(state);
        this.destinationPanel.updateStateObjectWithPanelInfo(state);
    }

    public String getTitle() {
        return "Select Address Range(s)";
    }

    public void initialize() {
        this.sourcePanel.initialize();
        this.destinationPanel.initialize();
    }

    public boolean isValidInformation() {
        return this.sourcePanel.isValidInformation() && this.destinationPanel.isValidInformation();
    }
}

