/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.ms.win.w32;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.rzo.yajsw.os.Mouse;

public class WindowsXPMouse
implements Mouse {
    public final User32 USER32INST;
    public final Kernel32 KERNEL32INST;
    public static LowLevelMouseProc mouseHook;
    public static Runnable action;
    public static Mouse instance;
    public WinUser.HHOOK hhk;
    public Thread thrd;
    public boolean threadFinish = true;
    public boolean isHooked = false;
    public static final int WM_MOUSEMOVE = 512;
    public static final int WM_LBUTTONDOWN = 513;
    public static final int WM_LBUTTONUP = 514;
    public static final int WM_RBUTTONDOWN = 516;
    public static final int WM_RBUTTONUP = 517;
    public static final int WM_MBUTTONDOWN = 519;
    public static final int WM_MBUTTONUP = 520;

    public WindowsXPMouse() {
        if (!Platform.isWindows()) {
            throw new UnsupportedOperationException("Not supported on this platform.");
        }
        this.USER32INST = User32.INSTANCE;
        this.KERNEL32INST = Kernel32.INSTANCE;
        mouseHook = this.hookTheMouse();
        Native.setProtected(true);
    }

    public static Mouse instance() {
        if (instance == null) {
            instance = new WindowsXPMouse();
        }
        return instance;
    }

    @Override
    public synchronized void unregisterMouseUpListner() {
        if (this.thrd == null) {
            return;
        }
        this.threadFinish = true;
        if (this.thrd.isAlive()) {
            this.thrd.interrupt();
            this.thrd = null;
        }
        this.isHooked = false;
    }

    public boolean isIsHooked() {
        return this.isHooked;
    }

    @Override
    public synchronized void registerMouseUpListner(Runnable action, Executor executor) {
        if (this.thrd != null) {
            return;
        }
        WindowsXPMouse.action = action;
        this.thrd = new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        if (!WindowsXPMouse.this.isHooked) {
                            WindowsXPMouse.this.hhk = WindowsXPMouse.this.USER32INST.SetWindowsHookEx(14, (WinUser.HOOKPROC)mouseHook, (WinDef.HINSTANCE)WindowsXPMouse.this.KERNEL32INST.GetModuleHandle(null), 0);
                            WindowsXPMouse.this.isHooked = true;
                            WinUser.MSG msg = new WinUser.MSG();
                            while (WindowsXPMouse.this.USER32INST.GetMessage(msg, null, 0, 0) != 0) {
                                System.out.println("got message");
                                WindowsXPMouse.this.USER32INST.TranslateMessage(msg);
                                WindowsXPMouse.this.USER32INST.DispatchMessage(msg);
                                System.out.print(WindowsXPMouse.this.isHooked);
                                if (WindowsXPMouse.this.isHooked) continue;
                                break block4;
                            }
                            break block4;
                        }
                        System.out.println("The Hook is already installed.");
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                        System.err.println("Caught exception in MouseHook!");
                    }
                }
                WindowsXPMouse.this.USER32INST.UnhookWindowsHookEx(WindowsXPMouse.this.hhk);
                WindowsXPMouse.this.hhk = null;
            }
        }, "Named thread");
        this.threadFinish = false;
        this.thrd.start();
    }

    public LowLevelMouseProc hookTheMouse() {
        return new LowLevelMouseProc(){

            @Override
            public WinDef.LRESULT callback(int nCode, WinDef.WPARAM wParam, MOUSEHOOKSTRUCT info) {
                WinDef.LRESULT result = WindowsXPMouse.this.USER32INST.CallNextHookEx(WindowsXPMouse.this.hhk, nCode, wParam, new WinDef.LPARAM(Pointer.nativeValue((Pointer)info.getPointer())));
                if (nCode >= 0) {
                    int action = wParam.intValue();
                    switch (action) {
                        case 513: {
                            break;
                        }
                        case 516: {
                            WindowsXPMouse.action.run();
                            break;
                        }
                        case 519: {
                            break;
                        }
                        case 514: {
                            WindowsXPMouse.action.run();
                            break;
                        }
                        case 512: {
                            break;
                        }
                    }
                    if (WindowsXPMouse.this.threadFinish) {
                        WindowsXPMouse.this.USER32INST.PostQuitMessage(0);
                    }
                }
                return result;
            }
        };
    }

    public static void main(String[] args) {
    }

    public static class MOUSEHOOKSTRUCT
    extends Structure {
        public WinDef.POINT pt;
        public WinDef.HWND hwnd;
        public int wHitTestCode;
        public BaseTSD.ULONG_PTR dwExtraInfo;

        protected List getFieldOrder() {
            return Arrays.asList("pt", "hwnd", "wHitTestCode", "dwExtraInfo");
        }

        public static class ByReference
        extends MOUSEHOOKSTRUCT
        implements Structure.ByReference {
        }
    }

    private static interface LowLevelMouseProc
    extends WinUser.HOOKPROC {
        public WinDef.LRESULT callback(int var1, WinDef.WPARAM var2, MOUSEHOOKSTRUCT var3);
    }
}

