/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.catacombae.hfsexplorer.GUIUtil;
import org.catacombae.hfsexplorer.PrefixFileFilter;
import org.catacombae.hfsexplorer.fs.AppleSingleHandler;
import org.catacombae.hfsexplorer.fs.ResourceForkReader;
import org.catacombae.hfsexplorer.gui.ResourceForkViewPanel;
import org.catacombae.hfsexplorer.types.applesingle.EntryDescriptor;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.jdesktop.layout.GroupLayout;

public class ResourceViewer
extends JFrame {
    private final ResourceForkViewPanel resourceForkViewPanel = new ResourceForkViewPanel(null);
    private JPanel backgroundPanel;
    private JMenuBar menuBar;
    private JMenu openMenu;
    private JMenuItem openMenuItem;

    public ResourceViewer() {
        super("Resource Viewer");
        this.initComponents();
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.backgroundPanel.add(this.resourceForkViewPanel);
        this.openMenuItem.addActionListener(new ActionListener(){
            private JFileChooser jfc = new JFileChooser();
            {
                this.jfc.setFileSelectionMode(0);
                this.jfc.setMultiSelectionEnabled(false);
                this.jfc.setFileFilter(new PrefixFileFilter("AppleDouble resource forks (._*)", "._"));
            }

            public void actionPerformed(ActionEvent e) {
                if (this.jfc.showOpenDialog(ResourceViewer.this) == 0) {
                    ResourceViewer.this.loadFile(this.jfc.getSelectedFile());
                }
            }
        });
    }

    private void loadFile(File f) {
        block10: {
            ReadableFileStream fileStream = null;
            ResourceForkReader reader = null;
            try {
                fileStream = new ReadableFileStream(f);
                if (AppleSingleHandler.detectFileFormat((ReadableRandomAccessStream)fileStream, 0L) != null) {
                    try {
                        AppleSingleHandler handler = new AppleSingleHandler((ReadableRandomAccessStream)fileStream);
                        EntryDescriptor desc = handler.getResourceEntryDescriptor();
                        if (desc != null) {
                            fileStream = handler.getEntryStream(desc);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Unhandled exception while detecting AppleSingle format:");
                        e.printStackTrace();
                    }
                } else {
                    int res = JOptionPane.showConfirmDialog(this, "Invalid AppleDouble file.\nDo you want to attempt to load the file as raw resource fork data?", "Invalid file format", 0, 2);
                    if (res != 0) {
                        fileStream.close();
                        return;
                    }
                }
                reader = new ResourceForkReader((ReadableRandomAccessStream)fileStream);
                this.resourceForkViewPanel.loadResourceFork(reader);
                this.setTitle("Resource Viewer - [" + f.getName() + "]");
            }
            catch (Exception e) {
                e.printStackTrace();
                GUIUtil.displayExceptionDialog((Throwable)e, (Component)this);
                this.resourceForkViewPanel.loadResourceFork(null);
                if (reader != null) {
                    reader.close();
                }
                if (fileStream == null) break block10;
                fileStream.close();
            }
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.menuBar = new JMenuBar();
        this.openMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.backgroundPanel.setLayout(new BorderLayout());
        this.openMenu.setText("File");
        this.openMenuItem.setText("Open...");
        this.openMenu.add(this.openMenuItem);
        this.menuBar.add(this.openMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backgroundPanel, -1, 377, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backgroundPanel, -1, 279, Short.MAX_VALUE));
        this.pack();
    }

    public static void main(final String[] args) {
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ResourceViewer rv = new ResourceViewer();
                rv.pack();
                rv.setLocationRelativeTo(null);
                rv.setVisible(true);
                if (args.length > 0) {
                    rv.loadFile(new File(args[0]));
                }
            }
        });
    }
}

