/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.rtti;

import ghidra.app.cmd.data.AbstractCreateDataTypeModel;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.Rtti4Model;
import ghidra.app.cmd.data.rtti.RttiUtil;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.listing.Program;

public class VfTableModel
extends AbstractCreateDataTypeModel {
    public static final String DATA_TYPE_NAME = "vftable";
    private DataType dataType;
    private Rtti4Model rtti4Model;
    private int elementCount = -1;
    private Program lastProgram;
    private DataType lastDataType;
    private int lastElementCount = -1;

    public VfTableModel(Program program, Address vfTableAddress, DataValidationOptions validationOptions) {
        super(program, RttiUtil.getVfTableCount(program, vfTableAddress), vfTableAddress, validationOptions);
    }

    @Override
    public String getName() {
        return DATA_TYPE_NAME;
    }

    @Override
    public void validateModelSpecificInfo() throws InvalidDataTypeException {
        Program program = this.getProgram();
        Address startAddress = this.getAddress();
        Address metaAddress = this.getMetaAddress();
        Address rtti4Address = MSDataTypeUtils.getAbsoluteAddress((Program)program, (Address)metaAddress);
        this.rtti4Model = new Rtti4Model(program, rtti4Address, this.validationOptions);
        PointerDataType individualEntryDataType = new PointerDataType(program.getDataTypeManager());
        long entrySize = individualEntryDataType.getLength();
        long numEntries = RttiUtil.getVfTableCount(program, startAddress);
        if (numEntries == 0L) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't have a valid vf table.");
        }
        Address vfTableFieldAddress = startAddress;
        int ordinal = 0;
        while ((long)ordinal < numEntries && vfTableFieldAddress != null) {
            Address functionAddress = MSDataTypeUtils.getAbsoluteAddress((Program)program, (Address)vfTableFieldAddress);
            if (functionAddress == null) {
                throw new InvalidDataTypeException(this.getName() + " at " + this.getAddress() + " doesn't refer to a valid function.");
            }
            try {
                vfTableFieldAddress = vfTableFieldAddress.add(entrySize);
            }
            catch (AddressOutOfBoundsException e) {
                if ((long)ordinal >= numEntries - 1L) break;
                throw new InvalidDataTypeException(this.getName() + " at " + this.getAddress() + " isn't valid.");
            }
            ++ordinal;
        }
    }

    private DataType getDataType(Program program) {
        if (program != this.lastProgram) {
            this.setIsDataTypeAlreadyBasedOnCount(true);
            this.lastProgram = program;
            this.lastDataType = null;
            this.lastElementCount = -1;
            this.lastElementCount = RttiUtil.getVfTableCount(program, this.getAddress());
            if (this.lastElementCount > 0) {
                DataTypeManager dataTypeManager = program.getDataTypeManager();
                PointerDataType pointerDt = new PointerDataType(dataTypeManager);
                ArrayDataType arrayDataType = new ArrayDataType((DataType)pointerDt, this.lastElementCount, pointerDt.getLength(), dataTypeManager);
                this.lastDataType = MSDataTypeUtils.getMatchingDataType((Program)program, (DataType)arrayDataType);
            } else {
                this.lastDataType = null;
            }
        }
        return this.lastDataType;
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = this.getDataType(this.getProgram());
        }
        return this.dataType;
    }

    @Override
    protected int getDataTypeLength() {
        DataType dt = this.getDataType();
        return dt != null ? dt.getLength() : 0;
    }

    public Address getVirtualFunctionPointer(int tableElementIndex) {
        Address tableAddress = this.getAddress();
        int defaultPointerSize = this.getDefaultPointerSize();
        Address address = tableAddress.add((long)(defaultPointerSize * tableElementIndex));
        return MSDataTypeUtils.getAbsoluteAddress((Program)this.getProgram(), (Address)address);
    }

    public int getElementCount() {
        if (this.elementCount == -1) {
            this.elementCount = RttiUtil.getVfTableCount(this.getProgram(), this.getAddress());
        }
        return this.elementCount;
    }

    public TypeDescriptorModel getRtti0Model() throws InvalidDataTypeException {
        this.checkValidity();
        return this.rtti4Model.getRtti0Model();
    }

    private Address getMetaAddress() {
        return this.getAddress().subtract((long)this.getProgram().getDefaultPointerSize());
    }
}

