/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.rzo.netty.ahessian.crypto.ClientCryptoData;
import org.rzo.netty.ahessian.crypto.CryptoConstants;
import org.rzo.netty.ahessian.crypto.ServerCryptoData;
import org.rzo.netty.ahessian.crypto.ServerCryptoFilterInbound;
import org.rzo.netty.ahessian.crypto.StreamCipherFactory;
import org.rzo.netty.ahessian.crypto.Util;
import org.rzo.netty.ahessian.log.OutLogger;

public class ClientCryptoFilterInbound
extends ChannelInboundHandlerAdapter
implements CryptoConstants {
    ClientCryptoData _data;

    public ClientCryptoFilterInbound(ClientCryptoData data) {
        this._data = data;
    }

    public void channelRead(ChannelHandlerContext ctx, Object e) throws Exception {
        if (this._data._decodeCipher != null) {
            ByteBuf m = Util.code(this._data._decodeCipher, (ByteBuf)e, true);
            ctx.fireChannelRead(e);
        } else {
            ByteBuf b = (ByteBuf)e;
            if (this._data._encodedPublicKey == null) {
                int size = b.readInt();
                this._data._encodedPublicKey = new byte[size];
            }
            int available = b.readableBytes();
            int toRead = Math.min(this._data._encodedPublicKey.length - this._data._bytesRead, available);
            b.readBytes(this._data._encodedPublicKey, this._data._bytesRead, toRead);
            this._data._bytesRead += toRead;
            if (this._data._bytesRead == this._data._encodedPublicKey.length) {
                this.sendSecretKey(ctx);
            }
        }
    }

    private Cipher getAsymCipher() {
        try {
            KeyFactory fact = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec ks = new X509EncodedKeySpec(this._data._encodedPublicKey);
            PublicKey pubKey = fact.generatePublic(ks);
            String type = "".equals("ECB/NOPADDING") ? "RSA" : "RSA/ECB/NOPADDING";
            Cipher result = Cipher.getInstance(type);
            result.init(1, pubKey);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private byte[] getSymKey() {
        try {
            byte[] key = new byte[16];
            this._data._secureRandom.nextBytes(key);
            return key;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private byte[] getIv() {
        byte[] iv = new byte[8];
        this._data._secureRandom.nextBytes(iv);
        return iv;
    }

    private void sendSecretKey(ChannelHandlerContext ctx) {
        try {
            byte[] symKeyEncoded = this.getSymKey();
            byte[] ivEncoded = this.getIv();
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            b.write(ivEncoded);
            b.write(symKeyEncoded);
            if (this._data._password != null) {
                b.write(this._data._password);
            }
            b.flush();
            System.out.println("generated iv+key: " + OutLogger.asString(b.toByteArray()));
            Cipher asymCipher = this.getAsymCipher();
            byte[] encryptedIvSymKey = asymCipher.doFinal(b.toByteArray());
            ByteBuf cb = Unpooled.buffer();
            cb.writeInt(encryptedIvSymKey.length);
            cb.writeBytes(encryptedIvSymKey);
            Channel channel = ctx.channel();
            ctx.write((Object)cb).sync();
            this._data._encodeCipher = StreamCipherFactory.createCipher("RC4");
            this._data._encodeCipher.engineInitEncrypt(symKeyEncoded, ivEncoded);
            this._data._decodeCipher = StreamCipherFactory.createCipher("RC4");
            this._data._decodeCipher.engineInitDecrypt(symKeyEncoded, ivEncoded);
            ctx.fireChannelActive();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setPassword(byte[] password) {
        if (password == null || password.length == 0) {
            return;
        }
        int length = Math.min(15, password.length);
        System.arraycopy(password, 0, this._data._password, 0, length);
    }

    public static void main(String[] args) {
        ServerCryptoFilterInbound s = new ServerCryptoFilterInbound(new ServerCryptoData());
        ClientCryptoFilterInbound c = new ClientCryptoFilterInbound(new ClientCryptoData());
        c._data._encodedPublicKey = s.getPublicKeyEncoded();
        c.sendSecretKey(null);
    }
}

