/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.diff;

import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.diff.ProgramDiffPlugin;
import ghidra.app.plugin.core.gotoquery.GoToHelper;
import ghidra.app.services.GoToOverrideService;
import ghidra.app.services.GoToService;
import ghidra.app.services.GoToServiceListener;
import ghidra.app.services.NavigationHistoryService;
import ghidra.app.services.QueryData;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.task.TaskMonitor;

public class DiffGoToService
implements GoToService {
    private GoToService goToService;
    private ProgramDiffPlugin diffPlugin;
    private GoToHelper helper;

    public DiffGoToService(GoToService goToService, ProgramDiffPlugin diffPlugin) {
        this.goToService = goToService;
        this.diffPlugin = diffPlugin;
        this.helper = new GoToHelper(diffPlugin.getTool());
    }

    public GoToOverrideService getOverrideService() {
        return this.goToService.getOverrideService();
    }

    public boolean goTo(ProgramLocation loc) {
        return this.diffGoTo(loc);
    }

    public boolean goTo(Navigatable navigatable, Program program, Address address, Address refAddress) {
        ProgramLocation location = this.helper.getLocation(program, refAddress, address);
        return this.goTo(navigatable, location, program);
    }

    public boolean goTo(ProgramLocation loc, Program program) {
        if (program == null || program == this.diffPlugin.getSecondProgram()) {
            return this.diffGoTo(loc);
        }
        this.showProgramFailureStatus();
        return false;
    }

    public boolean goTo(Navigatable navigatable, ProgramLocation loc, Program program) {
        if (loc == null || loc.getAddress() == null) {
            return false;
        }
        if (program == null) {
            program = navigatable.getProgram();
        }
        if (program == null) {
            return false;
        }
        if (program == this.diffPlugin.getSecondProgram()) {
            return this.diffGoTo(loc);
        }
        return false;
    }

    public boolean goTo(Navigatable navigatable, Address goToAddress) {
        Memory memory;
        if (goToAddress == null) {
            return false;
        }
        if (navigatable == null) {
            return this.diffGoTo(goToAddress);
        }
        Program program = navigatable.getProgram();
        if (program != null && !(memory = program.getMemory()).contains(goToAddress)) {
            return false;
        }
        return this.goTo(goToAddress, program);
    }

    public boolean goTo(Address currentAddress, Address goToAddress) {
        if (this.diffGoTo(goToAddress)) {
            return true;
        }
        return this.goToService.goTo(currentAddress, goToAddress);
    }

    public boolean goTo(Address goToAddress) {
        return this.diffGoTo(goToAddress);
    }

    public boolean goTo(Address goToAddress, Program program) {
        if (program == null || program == this.diffPlugin.getSecondProgram()) {
            return this.diffGoTo(goToAddress);
        }
        this.showProgramFailureStatus();
        return false;
    }

    public boolean goToExternalLocation(ExternalLocation extLoc, boolean checkNavigationOption) {
        this.showProgramFailureStatus();
        return false;
    }

    public boolean goToExternalLocation(Navigatable navigatable, ExternalLocation extLoc, boolean checkNavigationOption) {
        this.showProgramFailureStatus();
        return false;
    }

    public boolean goToQuery(Address fromAddr, QueryData queryData, GoToServiceListener listener, TaskMonitor monitor) {
        return this.goToService.goToQuery(fromAddr, queryData, listener, monitor);
    }

    public boolean goToQuery(Navigatable navigatable, Address fromAddr, QueryData queryData, GoToServiceListener listener, TaskMonitor monitor) {
        return this.goToService.goToQuery(navigatable, fromAddr, queryData, listener, monitor);
    }

    public void setOverrideService(GoToOverrideService override) {
    }

    public Navigatable getDefaultNavigatable() {
        return this.goToService.getDefaultNavigatable();
    }

    private void showProgramFailureStatus() {
        this.diffPlugin.getTool().setStatusInfo("Can't navigate from the Diff program to another program.");
    }

    private boolean diffGoTo(ProgramLocation loc) {
        if (loc == null) {
            return false;
        }
        Address addr = loc.getAddress();
        if (addr == null) {
            return false;
        }
        this.saveLocation();
        boolean went = this.diffPlugin.getListingPanel().goTo(loc);
        this.saveLocation();
        return went;
    }

    private boolean diffGoTo(Address addr) {
        if (addr == null) {
            return false;
        }
        this.saveLocation();
        boolean went = this.diffPlugin.getListingPanel().goTo(addr);
        this.saveLocation();
        return went;
    }

    private void saveLocation() {
        Program firstProgram = this.diffPlugin.getFirstProgram();
        if (firstProgram == null) {
            return;
        }
        NavigationHistoryService historyService = (NavigationHistoryService)this.diffPlugin.getTool().getService(NavigationHistoryService.class);
        if (historyService != null) {
            historyService.addNewLocation(this.goToService.getDefaultNavigatable());
        }
    }
}

