/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.bplist;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class BinaryPropertyListTrailer
implements StructConverter {
    private long trailerIndex;
    private int offsetSize;
    private int objectRefSize;
    private int objectCount;
    private int topObject;
    private int offsetTableOffset;
    private int[] offsetTable;

    public BinaryPropertyListTrailer(BinaryReader reader) throws IOException {
        this.trailerIndex = reader.length() - 32L;
        this.offsetSize = reader.readByte(this.trailerIndex + 6L) & 0xFF;
        this.objectRefSize = reader.readByte(this.trailerIndex + 7L) & 0xFF;
        this.objectCount = reader.readInt(this.trailerIndex + 12L) & 0xFFFFFFFF;
        this.topObject = reader.readInt(this.trailerIndex + 20L) & 0xFFFFFFFF;
        this.offsetTableOffset = reader.readInt(this.trailerIndex + 28L) & 0xFFFFFFFF;
        this.offsetTable = new int[this.objectCount];
        for (int i = 0; i < this.objectCount; ++i) {
            if (this.offsetSize == 4) {
                this.offsetTable[i] = reader.readInt((long)(this.offsetTableOffset + i * this.offsetSize));
                continue;
            }
            if (this.offsetSize == 2) {
                this.offsetTable[i] = reader.readShort((long)(this.offsetTableOffset + i * this.offsetSize)) & 0xFFFF;
                continue;
            }
            if (this.offsetSize == 1) {
                this.offsetTable[i] = reader.readByte((long)(this.offsetTableOffset + i * this.offsetSize)) & 0xFF;
                continue;
            }
            throw new RuntimeException("Invalid offset size in binary PList");
        }
    }

    public int getOffsetSize() {
        return this.offsetSize;
    }

    public int getObjectRefSize() {
        return this.objectRefSize;
    }

    public int getObjectCount() {
        return this.objectCount;
    }

    public int getTopObject() {
        return this.topObject;
    }

    public int getOffsetTableOffset() {
        return this.offsetTableOffset;
    }

    public int[] getOffsetTable() {
        return this.offsetTable;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("bplist_trailer", 0);
        structure.add(BYTE, "unk0", null);
        structure.add(BYTE, "unk1", null);
        structure.add(BYTE, "unk2", null);
        structure.add(BYTE, "unk3", null);
        structure.add(BYTE, "unk4", null);
        structure.add(BYTE, "unk5", null);
        structure.add(BYTE, "offsetSize", null);
        structure.add(BYTE, "objectRefSize", null);
        structure.add(QWORD, "objectCount", null);
        structure.add(QWORD, "topObject", null);
        structure.add(QWORD, "offsetTableOffset", null);
        return structure;
    }

    public long getTrailerIndex() {
        return this.trailerIndex;
    }
}

