/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.png;

import ghidra.file.formats.ios.png.CrushedPNGConstants;
import ghidra.file.formats.ios.png.PNGChunk;
import java.io.IOException;
import java.nio.ByteBuffer;

public class IHDRChunk {
    private int length;
    private byte[] chunkID;
    private int imgWidth;
    private int imgHeight;
    private byte bitDepth;
    private byte colorType;
    private byte compressionMethod;
    private byte filterMethod;
    private byte interlaceMethod;
    private int crc32;
    private int bitsPerPalette;
    private int rowFilterBytes;

    public IHDRChunk(PNGChunk chunk) throws IOException {
        if (chunk.getIDString().equals("IHDR")) {
            this.length = chunk.getLength();
            this.chunkID = chunk.getChunkIDBytes();
            byte[] data = chunk.getData();
            if (data.length != 13) {
                throw new IOException("Data length " + data.length + " does not equal the required length of 13");
            }
            ByteBuffer buff = ByteBuffer.wrap(data);
            this.imgWidth = buff.getInt();
            this.imgHeight = buff.getInt();
            this.bitDepth = buff.get();
            this.colorType = buff.get();
            this.compressionMethod = buff.get();
            this.filterMethod = buff.get();
            this.interlaceMethod = buff.get();
        } else {
            throw new IOException("Error processing IHDR Chunk. Invalid chunk name: " + chunk.getIDString() + " found");
        }
        this.crc32 = chunk.getCrc32();
        this.calculateBitsPerPalette();
        this.calculateRowFilterBytes();
    }

    private void calculateBitsPerPalette() throws IOException {
        switch (this.colorType) {
            case 0: {
                if (this.bitDepth == 1 || this.bitDepth == 2 || this.bitDepth == 4 || this.bitDepth == 8 || this.bitDepth == 16) {
                    this.bitsPerPalette = this.bitDepth;
                    break;
                }
            }
            case 2: {
                if (this.bitDepth == 8 || this.bitDepth == 16) {
                    this.bitsPerPalette = 3 * this.bitDepth;
                    break;
                }
            }
            case 3: {
                if (this.bitDepth == 1 || this.bitDepth == 2 || this.bitDepth == 4 || this.bitDepth == 8) {
                    this.bitsPerPalette = this.bitDepth;
                    break;
                }
            }
            case 4: {
                if (this.bitDepth == 8 || this.bitDepth == 16) {
                    this.bitsPerPalette = 4 * this.bitDepth;
                    break;
                }
            }
            case 6: {
                if (this.bitDepth == 8 || this.bitDepth == 16) {
                    this.bitsPerPalette = 4 * this.bitDepth;
                    break;
                }
            }
            default: {
                throw new IOException("Unknown color type: " + this.colorType);
            }
        }
    }

    private void calculateRowFilterBytes() {
        if (this.interlaceMethod == 1) {
            for (int pass = 0; pass < CrushedPNGConstants.STARTING_ROW.length; ++pass) {
                int height = (this.imgHeight - CrushedPNGConstants.STARTING_ROW[pass] + CrushedPNGConstants.ROW_INCREMENT[pass - 1]) / CrushedPNGConstants.ROW_INCREMENT[pass];
                this.rowFilterBytes += height;
            }
        }
        this.rowFilterBytes = this.imgHeight;
    }

    public int getImgWidth() {
        return this.imgWidth;
    }

    public int getImgHeight() {
        return this.imgHeight;
    }

    public byte getBitDepth() {
        return this.bitDepth;
    }

    public byte getColorType() {
        return this.colorType;
    }

    public byte getCompressionMethod() {
        return this.compressionMethod;
    }

    public byte getFilterMethod() {
        return this.filterMethod;
    }

    public byte getInterlaceMethod() {
        return this.interlaceMethod;
    }

    public int getBitsPerPalette() {
        return this.bitsPerPalette;
    }

    public int getBytesPerPalette() {
        return (this.bitsPerPalette + 7) / 8;
    }

    public int getBytesPerLine() {
        return (this.imgWidth * this.bitsPerPalette + 7) / 8;
    }

    public int getRowFilterBytes() {
        return this.rowFilterBytes;
    }

    public byte[] getChunkBytes() {
        return ByteBuffer.allocate(13).putInt(this.imgWidth).putInt(this.imgHeight).put(this.bitDepth).put(this.colorType).put(this.compressionMethod).put(this.filterMethod).array();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Data Length: " + this.length + "\n");
        buff.append("Chunk ID: " + new String(this.chunkID) + "\n");
        buff.append("Width: " + this.imgWidth + "\n");
        buff.append("Height: " + this.imgHeight + "\n");
        buff.append("Bit Depth: " + this.bitDepth + "\n");
        buff.append("Color Type: " + this.colorType + "\n");
        buff.append("Compression Method: " + this.compressionMethod + "\n");
        buff.append("Filter Method: " + this.filterMethod + "\n");
        buff.append("Interlace Method: " + this.interlaceMethod + "\n");
        buff.append("Bits Per Palette: " + this.bitsPerPalette + "\n");
        buff.append("Bytes Per Line: " + (this.imgWidth * this.bitsPerPalette + 7) / 8 + "\n");
        buff.append("CRC32: " + this.crc32 + "\n");
        return buff.toString();
    }
}

