/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import generic.stl.Pair;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlElement;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PropertyFile {
    public static final String PROPERTY_EXT = ".prp";
    private static final String FILE_ID = "FILE_ID";
    protected File propertyFile;
    protected String storageName;
    protected String parentPath;
    protected String name;
    private HashMap<String, Pair<PropertyEntryType, String>> map = new HashMap();
    private static final ErrorHandler HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    };

    public PropertyFile(File dir, String storageName, String parentPath, String name) throws IOException {
        if (!dir.isAbsolute()) {
            throw new IllegalArgumentException("dir must be specified by an absolute path");
        }
        this.name = name;
        this.parentPath = parentPath;
        this.storageName = storageName;
        this.propertyFile = new File(dir, storageName + PROPERTY_EXT);
        if (this.propertyFile.exists()) {
            this.readState();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return !this.propertyFile.canWrite();
    }

    public String getPath() {
        if (this.parentPath == null || this.name == null) {
            return null;
        }
        if (this.parentPath.length() == 1) {
            return this.parentPath + this.name;
        }
        return this.parentPath + "/" + this.name;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public File getFolder() {
        return this.propertyFile.getParentFile();
    }

    public String getStorageName() {
        return this.storageName;
    }

    public String getFileID() {
        return this.getString(FILE_ID, null);
    }

    public void setFileID(String fileId) {
        this.putString(FILE_ID, fileId);
    }

    public int getInt(String propertyName, int defaultValue) {
        Pair<PropertyEntryType, String> pair = this.map.get(propertyName);
        if (pair == null || pair.first != PropertyEntryType.INT_TYPE) {
            return defaultValue;
        }
        try {
            String value = (String)pair.second;
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void putInt(String propertyName, int value) {
        this.map.put(propertyName, (Pair<PropertyEntryType, String>)new Pair((Object)PropertyEntryType.INT_TYPE, (Object)Integer.toString(value)));
    }

    public long getLong(String propertyName, long defaultValue) {
        Pair<PropertyEntryType, String> pair = this.map.get(propertyName);
        if (pair == null || pair.first != PropertyEntryType.LONG_TYPE) {
            return defaultValue;
        }
        try {
            String value = (String)pair.second;
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void putLong(String propertyName, long value) {
        this.map.put(propertyName, (Pair<PropertyEntryType, String>)new Pair((Object)PropertyEntryType.LONG_TYPE, (Object)Long.toString(value)));
    }

    public String getString(String propertyName, String defaultValue) {
        Pair<PropertyEntryType, String> pair = this.map.get(propertyName);
        if (pair == null || pair.first != PropertyEntryType.STRING_TYPE) {
            return defaultValue;
        }
        String value = (String)pair.second;
        return value;
    }

    public void putString(String propertyName, String value) {
        this.map.put(propertyName, (Pair<PropertyEntryType, String>)new Pair((Object)PropertyEntryType.STRING_TYPE, (Object)value));
    }

    public boolean getBoolean(String propertyName, boolean defaultValue) {
        Pair<PropertyEntryType, String> pair = this.map.get(propertyName);
        if (pair == null || pair.first != PropertyEntryType.BOOLEAN_TYPE) {
            return defaultValue;
        }
        String value = (String)pair.second;
        return Boolean.parseBoolean(value);
    }

    public void putBoolean(String propertyName, boolean value) {
        this.map.put(propertyName, (Pair<PropertyEntryType, String>)new Pair((Object)PropertyEntryType.BOOLEAN_TYPE, (Object)Boolean.toString(value)));
    }

    public void remove(String propertyName) {
        this.map.remove(propertyName);
    }

    public long lastModified() {
        return this.propertyFile.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeState() throws IOException {
        try (PrintWriter writer = new PrintWriter(this.propertyFile);){
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<FILE_INFO>");
            writer.println("    <BASIC_INFO>");
            for (Map.Entry<String, Pair<PropertyEntryType, String>> entry : this.map.entrySet()) {
                String propertyName = entry.getKey();
                String propertyType = ((PropertyEntryType)((Object)entry.getValue().first)).rep;
                String propertyValue = (String)entry.getValue().second;
                writer.print("        <STATE NAME=\"");
                writer.print(XmlUtilities.escapeElementEntities((String)propertyName));
                writer.print("\" TYPE=\"");
                writer.print(XmlUtilities.escapeElementEntities((String)propertyType));
                writer.print("\" VALUE=\"");
                writer.print(XmlUtilities.escapeElementEntities((String)propertyValue));
                writer.println("\" />");
            }
            writer.println("    </BASIC_INFO>");
            writer.println("</FILE_INFO>");
        }
    }

    public void readState() throws IOException {
        NonThreadedXmlPullParserImpl parser = null;
        try {
            XmlElement state;
            parser = new NonThreadedXmlPullParserImpl(this.propertyFile, HANDLER, false);
            XmlElement file_info = parser.start(new String[]{"FILE_INFO"});
            XmlElement basic_info = parser.start(new String[]{"BASIC_INFO"});
            while ((state = parser.softStart(new String[]{"STATE"})) != null) {
                String propertyName = state.getAttribute("NAME");
                String propertyTypeString = state.getAttribute("TYPE");
                String propertyValue = state.getAttribute("VALUE");
                PropertyEntryType propertyType = PropertyEntryType.lookup(propertyTypeString);
                this.map.put(propertyName, (Pair<PropertyEntryType, String>)new Pair((Object)propertyType, (Object)propertyValue));
                parser.end(state);
            }
            parser.end(basic_info);
            parser.end(file_info);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            throw new InvalidObjectException("XML parse error in properties file");
        }
        finally {
            if (parser != null) {
                parser.dispose();
            }
        }
    }

    public void moveTo(File newParent, String newStorageName, String newParentPath, String newName) throws DuplicateFileException, IOException {
        if (!newParent.equals(this.propertyFile.getParentFile()) || !newStorageName.equals(this.storageName)) {
            File newPropertyFile = new File(newParent, newStorageName + PROPERTY_EXT);
            if (newPropertyFile.exists()) {
                throw new DuplicateFileException(newName + " already exists");
            }
            if (!this.propertyFile.renameTo(newPropertyFile)) {
                throw new IOException("move failed");
            }
            this.propertyFile = newPropertyFile;
            this.storageName = newStorageName;
        }
        this.parentPath = newParentPath;
        this.name = newName;
    }

    public boolean exists() {
        return this.propertyFile.exists();
    }

    public void delete() {
        this.propertyFile.delete();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyFile == null ? 0 : this.propertyFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyFile other = (PropertyFile)obj;
        return !(this.propertyFile == null ? other.propertyFile != null : !this.propertyFile.equals(other.propertyFile));
    }

    private static enum PropertyEntryType {
        INT_TYPE("int"),
        LONG_TYPE("long"),
        BOOLEAN_TYPE("boolean"),
        STRING_TYPE("string");

        private final String rep;

        private PropertyEntryType(String rep) {
            this.rep = rep;
        }

        public static PropertyEntryType lookup(String rep) {
            for (PropertyEntryType entryType : PropertyEntryType.values()) {
                if (!rep.equals(entryType.rep)) continue;
                return entryType;
            }
            return null;
        }
    }
}

