/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.JavaSourceLine;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JavaSourceFile {
    private final String filename;
    private final List<JavaSourceLine> linesList = new ArrayList<JavaSourceLine>();
    private int initialLineCount;

    public JavaSourceFile(String filename) {
        this.filename = filename;
        this.loadFile();
        this.initialLineCount = this.linesList.size();
    }

    private JavaSourceFile(String filename, List<JavaSourceLine> originalLines) {
        this.filename = filename;
        this.linesList.addAll(originalLines);
        this.initialLineCount = this.linesList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.filename));
            String newline = System.getProperty("line.separator");
            int lineNumber = 0;
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.linesList.add(new JavaSourceLine(line + newline, ++lineNumber));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean hasChanges() {
        return this.initialLineCount != this.linesList.size() || this.hasLineChanges();
    }

    private boolean hasLineChanges() {
        for (JavaSourceLine line : this.linesList) {
            if (!line.hasChanges()) continue;
            return true;
        }
        return false;
    }

    public int getImportSectionStartLineNumber() {
        for (JavaSourceLine line : this.linesList) {
            String text = line.getText();
            if (!text.trim().startsWith("import")) continue;
            return line.getLineNumber();
        }
        return -1;
    }

    public int getLineNumberAfterStatementAtLine(int lineNumber) {
        JavaSourceLine startLine = this.getStatementStartForLine(lineNumber);
        if (startLine.getText().trim().endsWith(";")) {
            return lineNumber + 1;
        }
        List<JavaSourceLine> statementLines = this.getRemainingLinesForStatement(startLine, startLine.getLineNumber() + 1);
        JavaSourceLine lastLine = statementLines.get(statementLines.size() - 1);
        return lastLine.getLineNumber() + 1;
    }

    public void removeJavaStatement(int lineNumber) {
        JavaSourceLine startLine = this.getStatementStartForLine(lineNumber);
        if (startLine.getText().trim().endsWith(";")) {
            startLine.delete();
            return;
        }
        ArrayList<JavaSourceLine> linesToClear = new ArrayList<JavaSourceLine>(this.getRemainingLinesForStatement(startLine, startLine.getLineNumber() + 1));
        linesToClear.add(0, startLine);
        int size = linesToClear.size();
        for (int i = 0; i < size - 1; ++i) {
            ((JavaSourceLine)linesToClear.get(i)).delete();
        }
        JavaSourceLine lastLine = (JavaSourceLine)linesToClear.get(size - 1);
        String text = lastLine.getText();
        int count = StringUtils.countMatches((CharSequence)text, (char)';');
        if (count == 1) {
            lastLine.delete();
            return;
        }
        text = text.substring(text.indexOf(";") + 1);
        lastLine.setText(text);
    }

    private List<JavaSourceLine> getRemainingLinesForStatement(JavaSourceLine statementStart, int startLineNumber) {
        TokenPairMatcher parenMatcher = new TokenPairMatcher('(', ')');
        TokenPairMatcher braceMatcher = new TokenPairMatcher('{', '}');
        String text = statementStart.getText();
        parenMatcher.scanLine(text);
        braceMatcher.scanLine(text);
        ArrayList<JavaSourceLine> list = new ArrayList<JavaSourceLine>();
        List<JavaSourceLine> remainingList = this.linesList.subList(--startLineNumber, this.linesList.size());
        for (JavaSourceLine sourceLine : remainingList) {
            list.add(sourceLine);
            if (!this.isValidEndOfStatement(parenMatcher, braceMatcher, sourceLine)) continue;
            break;
        }
        return list;
    }

    private boolean isValidEndOfStatement(TokenPairMatcher parenMatcher, TokenPairMatcher braceMatcher, JavaSourceLine sourceLine) {
        String text = sourceLine.getText();
        parenMatcher.scanLine(text);
        braceMatcher.scanLine(text);
        if (!parenMatcher.isBalanced() || !braceMatcher.isBalanced()) {
            return false;
        }
        return text.trim().endsWith(";");
    }

    public JavaSourceLine getLineContaintingStatementStart(int lineNumber) {
        return this.getStatementStartForLine(lineNumber);
    }

    public String getJavaStatementStartingAtLine(int firstUseLineNumber) {
        JavaSourceLine startLine = this.getStatementStartForLine(firstUseLineNumber);
        String lineText = startLine.getText();
        if (lineText.trim().endsWith(";")) {
            return lineText;
        }
        StringBuffer buffy = new StringBuffer(startLine.getText());
        List<JavaSourceLine> statementLines = this.getRemainingLinesForStatement(startLine, startLine.getLineNumber() + 1);
        for (JavaSourceLine sourceLine : statementLines) {
            buffy.append(sourceLine.getText().trim());
        }
        return buffy.toString();
    }

    private JavaSourceLine getStatementStartForLine(int lineNumber) {
        JavaSourceLine backwardsLine = this.getStatementFromNextSemicolon(lineNumber);
        if (backwardsLine != null) {
            return backwardsLine;
        }
        int currentLineNumber = lineNumber;
        TokenMatcher semicolonMatcher = new TokenMatcher(';');
        TokenMatcher equalsMatcher = new TokenMatcher('=');
        JavaSourceLine line = this.getLine(currentLineNumber);
        String text = line.getText();
        equalsMatcher.scanLine(text);
        if (equalsMatcher.foundToken()) {
            return line;
        }
        line = this.getLine(--currentLineNumber);
        text = line.getText();
        while (true) {
            equalsMatcher.scanLine(text);
            if (equalsMatcher.foundToken()) {
                return line;
            }
            semicolonMatcher.scanLine(text);
            if (semicolonMatcher.foundToken()) {
                return this.findNextNonBlankLine(++currentLineNumber);
            }
            line = this.getLine(--currentLineNumber);
            text = line.getText();
        }
    }

    private JavaSourceLine getStatementFromNextSemicolon(int lineNumber) {
        int startOffset;
        JavaSourceLine lastLine = this.findEndOfUnknownLine(lineNumber);
        if (this.isValidStatement(lastLine)) {
            return lastLine;
        }
        TokenPairMatcher parenMatcher = new TokenPairMatcher('(', ')');
        TokenPairMatcher braceMatcher = new TokenPairMatcher('{', '}');
        JavaSourceLine lastLineSeenFromStatement = null;
        int searchLineOffset = startOffset = lastLine.getLineNumber();
        do {
            JavaSourceLine searchLine = this.getLine(searchLineOffset--);
            String text = searchLine.getText();
            parenMatcher.scanLine(text);
            braceMatcher.scanLine(text);
            if (text.contains("serialVersion")) continue;
            TokenMatcher semicolonMatcher = new TokenMatcher(';');
            semicolonMatcher.scanLine(text);
            if (semicolonMatcher.foundToken() && startOffset != searchLineOffset + 1 && lastLineSeenFromStatement != null) {
                return this.findNextNonBlankLine(lastLineSeenFromStatement.getLineNumber());
            }
            TokenMatcher equalsMatcher = new TokenMatcher('=');
            equalsMatcher.scanLine(text);
            if (equalsMatcher.foundToken() && this.containsActionAssignment(text)) {
                return searchLine;
            }
            if (!text.contains("(") && !text.contains(".")) continue;
            lastLineSeenFromStatement = searchLine;
        } while (searchLineOffset > 0);
        return null;
    }

    private boolean isValidStatement(JavaSourceLine lastLine) {
        String text = lastLine.getText().trim();
        if (!text.endsWith(";")) {
            return false;
        }
        TokenPairMatcher parenMatcher = new TokenPairMatcher('(', ')');
        TokenPairMatcher braceMatcher = new TokenPairMatcher('{', '}');
        parenMatcher.scanLine(text);
        braceMatcher.scanLine(text);
        return parenMatcher.isBalanced() && braceMatcher.isBalanced();
    }

    private boolean containsActionAssignment(String text) {
        String[] equalsParts = text.split("=");
        String leftHandSide = equalsParts[0];
        String[] nameAndMaybeDeclaraction = leftHandSide.trim().split("\\s");
        if (nameAndMaybeDeclaraction.length == 2) {
            return nameAndMaybeDeclaraction[0].endsWith("Action");
        }
        return StringUtils.containsIgnoreCase((CharSequence)nameAndMaybeDeclaraction[0], (CharSequence)"action");
    }

    private JavaSourceLine findEndOfUnknownLine(int lineNumber) {
        JavaSourceLine currentLine = this.getLine(lineNumber);
        if (currentLine.getText().trim().endsWith(";")) {
            return currentLine;
        }
        ArrayList<JavaSourceLine> list = new ArrayList<JavaSourceLine>();
        int startLineNumber = lineNumber;
        List<JavaSourceLine> remainingList = this.linesList.subList(startLineNumber, this.linesList.size());
        for (JavaSourceLine sourceLine : remainingList) {
            list.add(sourceLine);
            if (!sourceLine.getText().trim().endsWith(";")) continue;
            break;
        }
        return (JavaSourceLine)list.get(list.size() - 1);
    }

    private JavaSourceLine findNextNonBlankLine(int lineNumber) {
        JavaSourceLine line;
        while ((line = this.getLine(lineNumber++)).getText().trim().equals("")) {
        }
        return line;
    }

    public JavaSourceLine getLine(int oneBasedLineNumber) {
        if (oneBasedLineNumber <= 0 || oneBasedLineNumber > this.linesList.size()) {
            throw new IndexOutOfBoundsException("File does not contain line number: " + oneBasedLineNumber);
        }
        return this.linesList.get(oneBasedLineNumber - 1);
    }

    public void save() {
        System.err.println("save on file: " + this.filename);
        if (!this.hasChanges()) {
            System.err.println("\tno changes to: " + this.filename);
            return;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.filename);
            this.doWrite(new PrintWriter(fileWriter));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void doWrite(PrintWriter writer) {
        for (JavaSourceLine line : this.linesList) {
            writer.write(line.getText());
        }
        writer.flush();
    }

    public String toString() {
        return this.filename;
    }

    public JavaSourceFile getOriginalSourceFileCopy() {
        return new JavaSourceFile(this.filename, this.copyOriginalLines());
    }

    private List<JavaSourceLine> copyOriginalLines() {
        ArrayList<JavaSourceLine> newList = new ArrayList<JavaSourceLine>();
        for (JavaSourceLine line : this.linesList) {
            newList.add(line.createOriginalClone());
        }
        return newList;
    }

    private class TokenPairMatcher {
        int runningTokenCount;
        private final char leftToken;
        private final char rightToken;

        private TokenPairMatcher(char leftToken, char rightToken) {
            this.leftToken = leftToken;
            this.rightToken = rightToken;
        }

        void scanLine(String line) {
            int length = line.length();
            for (int i = 0; i < length; ++i) {
                char charAt = line.charAt(i);
                if (charAt == this.leftToken) {
                    ++this.runningTokenCount;
                    continue;
                }
                if (charAt != this.rightToken) continue;
                --this.runningTokenCount;
            }
        }

        boolean isBalanced() {
            return this.runningTokenCount == 0;
        }

        public String toString() {
            return "TokenMatcher: [" + this.leftToken + ", " + this.rightToken + "] - count: " + this.runningTokenCount;
        }
    }

    private class TokenMatcher {
        private final char token;
        private boolean foundToken;

        private TokenMatcher(char token) {
            this.token = token;
        }

        void scanLine(String line) {
            if (this.foundToken) {
                return;
            }
            int length = line.length();
            for (int i = 0; i < length; ++i) {
                char charAt = line.charAt(i);
                if (charAt != this.token) continue;
                this.foundToken = true;
                break;
            }
        }

        boolean foundToken() {
            return this.foundToken;
        }
    }
}

