/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

public class MathUtilities {
    private MathUtilities() {
    }

    public static long unsignedDivide(long numerator, long denominator) {
        if (denominator < 0L) {
            throw new IllegalArgumentException("denomintor too big");
        }
        if (numerator >= 0L) {
            return numerator / denominator;
        }
        long numeratorDiv2 = numerator >>> 1;
        long result = numeratorDiv2 / denominator << 1;
        long remainder = numeratorDiv2 % denominator << 1;
        if ((remainder += numerator & 1L) >= denominator) {
            ++result;
        }
        return result;
    }

    public static long unsignedModulo(long numerator, long denominator) {
        if (denominator < 0L) {
            throw new IllegalArgumentException("denomintor too big");
        }
        if (numerator >= 0L) {
            return numerator % denominator;
        }
        long numeratorDiv2 = numerator >>> 1;
        long remainder = numeratorDiv2 % denominator << 1;
        return (remainder += numerator & 1L) % denominator;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static void main(String[] args) {
        long d = 4L;
        for (long i = 27L; i > -27L; --i) {
            long result = MathUtilities.unsignedDivide(i, d);
            long mod = MathUtilities.unsignedModulo(i, d);
            long v = result * d + mod;
            System.out.println("0x" + Long.toHexString(i) + " -> 0x" + Long.toHexString(result) + ":0x" + Long.toHexString(mod) + " -> 0x" + Long.toHexString(v));
        }
    }
}

