/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import com.jeta.forms.store.AbstractJETAPersistable;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.support.PropertyMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class PropertiesMemento
extends AbstractJETAPersistable {
    static final long serialVersionUID = -3299575217906477613L;
    public static final int VERSION = 2;
    private String m_class_name;
    private PropertyMap m_props = new PropertyMap();

    public PropertiesMemento() {
    }

    public PropertiesMemento(String string) {
        this.m_class_name = string;
    }

    public String getBeanClassName() {
        return this.m_class_name;
    }

    public void addProperty(String string, Serializable serializable) {
        this.m_props.put(string, serializable);
    }

    public boolean containsProperty(String string) {
        return this.m_props.containsKey(string);
    }

    public String getComponentName() {
        Object object = this.getPropertyValue("name");
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public Collection getPropertyNames() {
        return this.m_props.keySet();
    }

    public Object getPropertyValue(String string) {
        return this.m_props.get(string);
    }

    public void print() {
        System.out.println("................ properties memento: " + this.getBeanClassName() + "   ..............");
        Iterator iterator = this.m_props.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            System.out.println("          " + string + " = " + this.m_props.get(string));
        }
    }

    public void setBeanClassName(String string) {
        this.m_class_name = string;
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        int n = jETAObjectInput.readVersion();
        this.m_class_name = (String)jETAObjectInput.readObject("classname");
        if (n <= 1) {
            HashMap hashMap;
            Object object = jETAObjectInput.readObject("properties");
            this.m_props = object instanceof HashMap ? new PropertyMap((HashMap)object) : (PropertyMap)object;
            if (this.m_props == null) {
                this.m_props = new PropertyMap();
            }
            if ((hashMap = (HashMap)jETAObjectInput.readObject("customproperties")) != null) {
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    this.m_props.put(k, hashMap.get(k));
                }
            }
        } else {
            Object object = jETAObjectInput.readObject("properties");
            this.m_props = object instanceof HashMap ? new PropertyMap((HashMap)object) : (PropertyMap)object;
        }
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        jETAObjectOutput.writeVersion(2);
        jETAObjectOutput.writeObject("classname", this.m_class_name);
        jETAObjectOutput.writeObject("properties", this.m_props);
    }
}

