/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DialogComponentProvider;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.ProjectAccessPanel;
import ghidra.framework.main.ViewProjectAccessPanel;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.UserAccessException;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JComponent;

class ProjectAccessDialog
extends DialogComponentProvider {
    private RepositoryAdapter repository;
    private ProjectAccessPanel projectAccessPanel;

    ProjectAccessDialog(Plugin plugin, RepositoryAdapter repHandle, String[] knownUsers, boolean allowEditing) throws UserAccessException, IOException, NotConnectedException {
        super("Project Access List for " + repHandle.getName(), true);
        this.repository = repHandle;
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Edit_Project_Access_List"));
        this.projectAccessPanel = allowEditing ? new ProjectAccessPanel(knownUsers, this.repository, plugin.getTool()) : new ViewProjectAccessPanel(this.repository, plugin.getTool());
        this.addWorkPanel((JComponent)((Object)this.projectAccessPanel));
        if (allowEditing) {
            this.addOKButton();
            this.setOkEnabled(true);
            this.addCancelButton();
        } else {
            this.addCancelButton();
            this.setCancelButtonText("Close");
        }
    }

    protected void cancelCallback() {
        this.close();
    }

    protected void okCallback() {
        String statusMessage = null;
        try {
            this.repository.connect();
            this.repository.setUserList(this.projectAccessPanel.getProjectUsers(), this.projectAccessPanel.allowAnonymousAccess());
            this.close();
            Msg.info((Object)((Object)this), (Object)"Successfully updated project access list.");
        }
        catch (UserAccessException exc) {
            statusMessage = "Could not update the user list: " + exc.getMessage();
        }
        catch (NotConnectedException e) {
            statusMessage = "Server connection is down: " + e.getMessage();
        }
        catch (IOException exc) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)exc, (String)"Update User List", (Component)this.getComponent());
        }
        if (statusMessage != null) {
            this.setStatusText(statusMessage);
        }
    }
}

