/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatable;

import docking.ActionContext;
import docking.action.DockingAction;
import ghidra.framework.main.datatable.ProjectDataActionContext;
import ghidra.framework.main.datatree.ProjectDataTreeActionContext;

public abstract class ProjectDataTreeContextAction
extends DockingAction {
    public ProjectDataTreeContextAction(String name, String owner) {
        super(name, owner);
    }

    public final boolean isEnabledForContext(ActionContext actionContext) {
        if (!(actionContext instanceof ProjectDataTreeActionContext)) {
            return false;
        }
        ProjectDataTreeActionContext context = (ProjectDataTreeActionContext)actionContext;
        if (this.ignoreTransientProject(context)) {
            return false;
        }
        return this.isEnabledForContext(context);
    }

    protected boolean ignoreTransientProject(ProjectDataActionContext context) {
        if (this.supportsTransientProjectData()) {
            return false;
        }
        return context.isTransient();
    }

    protected boolean supportsTransientProjectData() {
        return false;
    }

    protected boolean isEnabledForContext(ProjectDataTreeActionContext context) {
        return context.hasOneOrMoreFilesAndFolders();
    }

    public final void actionPerformed(ActionContext context) {
        this.actionPerformed((ProjectDataTreeActionContext)context);
    }

    protected abstract void actionPerformed(ProjectDataTreeActionContext var1);

    public boolean isValidContext(ActionContext context) {
        if (!(context instanceof ProjectDataTreeActionContext)) {
            return false;
        }
        return this.isValidContext((ProjectDataTreeActionContext)context);
    }

    protected boolean isValidContext(ProjectDataTreeActionContext context) {
        return true;
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return false;
        }
        return this.isAddToPopup((ProjectDataTreeActionContext)context);
    }

    protected boolean isAddToPopup(ProjectDataTreeActionContext context) {
        return this.isEnabledForContext(context);
    }
}

