/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Field;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.BuiltinDBAdapter;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class BuiltinDBAdapterV0
extends BuiltinDBAdapter {
    static final String BUILT_IN_TABLE_NAME = "Built-in datatypes";
    static final int V0_BUILT_IN_NAME_COL = 0;
    static final int V0_BUILT_IN_CLASSNAME_COL = 1;
    static final int V0_BUILT_IN_CAT_COL = 2;
    static final Schema V0_SCHEMA = new Schema(0, "Data Type ID", new Class[]{StringField.class, StringField.class, LongField.class}, new String[]{"Name", "Class Name", "Category ID"});
    private Table table;

    public BuiltinDBAdapterV0(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.table = handle.createTable(BUILT_IN_TABLE_NAME, V0_SCHEMA, new int[]{2});
        } else {
            this.table = handle.getTable(BUILT_IN_TABLE_NAME);
            if (this.table == null) {
                throw new VersionException("Missing Table: Built-in datatypes");
            }
            if (this.table.getSchema().getVersion() != 0) {
                throw new VersionException("Expected version 0 for table Built-in datatypes but got " + this.table.getSchema().getVersion());
            }
        }
    }

    @Override
    public Record getRecord(long dataTypeID) throws IOException {
        return this.table.getRecord(dataTypeID);
    }

    @Override
    public long[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 2);
    }

    @Override
    public void updateRecord(Record record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    public boolean removeRecord(long dataID) throws IOException {
        return this.table.deleteRecord(dataID);
    }

    @Override
    public Record createRecord(String name, String className, long categoryID) throws IOException {
        long tableKey = this.table.getKey();
        if (tableKey <= 100L) {
            tableKey = 100L;
        }
        long key = DataTypeManagerDB.createKey(0, tableKey);
        Record record = V0_SCHEMA.createRecord(key);
        record.setString(0, name);
        record.setString(1, className);
        record.setLongValue(2, categoryID);
        this.table.putRecord(record);
        return record;
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }
}

