/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Field;
import db.LongField;
import db.Record;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.CategoryDBAdapter;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class CategoryDBAdapterV0
extends CategoryDBAdapter {
    static final String CATEGORY_TABLE_NAME = "Categories";
    static final int V0_CATEGORY_NAME_COL = 0;
    static final int V0_CATEGORY_PARENT_COL = 1;
    static final Schema V0_SCHEMA = new Schema(0, "Category ID", new Class[]{StringField.class, LongField.class}, new String[]{"Name", "Parent ID"});
    private Table table;

    public CategoryDBAdapterV0(DBHandle handle, int openMode) throws VersionException, IOException {
        if (openMode == 0) {
            this.table = handle.createTable(CATEGORY_TABLE_NAME, V0_SCHEMA, new int[]{1});
        } else {
            this.table = handle.getTable(CATEGORY_TABLE_NAME);
            if (this.table == null) {
                throw new VersionException("Missing Table: Categories");
            }
            if (this.table.getSchema().getVersion() != 0) {
                throw new VersionException("Expected version 0 for table Categories but got " + this.table.getSchema().getVersion());
            }
        }
    }

    @Override
    public Record getRecord(long categoryID) throws IOException {
        return this.table.getRecord(categoryID);
    }

    @Override
    public long[] getRecordIdsWithParent(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 1);
    }

    @Override
    void updateRecord(long categoryID, long parentID, String name) throws IOException {
        Record rec = this.table.getSchema().createRecord(categoryID);
        rec.setString(0, name);
        rec.setLongValue(1, parentID);
        this.table.putRecord(rec);
    }

    @Override
    void putRecord(Record record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    public Record createCategory(String name, long parentID) throws IOException {
        long key = this.table.getKey();
        if (key == 0L) {
            key = 1L;
        }
        Record rec = this.table.getSchema().createRecord(key);
        rec.setString(0, name);
        rec.setLongValue(1, parentID);
        this.table.putRecord(rec);
        return rec;
    }

    @Override
    public boolean removeCategory(long categoryID) throws IOException {
        return this.table.deleteRecord(categoryID);
    }

    @Override
    public Record getRootRecord() throws IOException {
        long[] keys = this.table.findRecords((Field)new LongField(-1L), 1);
        if (keys.length > 1) {
            throw new AssertException("Found " + keys.length + " entries for root category");
        }
        return this.getRecord(keys[0]);
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }
}

