/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.util;

import db.DBFieldIterator;
import db.Field;
import db.util.ErrorHandler;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IndexedAddressIterator
implements AddressIterator {
    private DBFieldIterator iter;
    private AddressMap addrMap;
    private ErrorHandler errHandler;

    public IndexedAddressIterator(DBFieldIterator iter, AddressMap addrMap, int colIndex, ErrorHandler errHandler) {
        this.iter = iter;
        this.addrMap = addrMap;
        this.errHandler = errHandler;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        try {
            return this.iter.hasNext();
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return false;
        }
    }

    @Override
    public Address next() {
        try {
            Field field = this.iter.next();
            if (field != null) {
                long addr = field.getLongValue();
                return this.addrMap.decodeAddress(addr);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Iterator<Address> iterator() {
        return this;
    }
}

