/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.constraint;

import generic.constraint.ConstraintData;
import ghidra.program.model.listing.Program;
import ghidra.util.constraint.ProgramConstraint;

public class CompilerConstraint
extends ProgramConstraint {
    private String compilerid;

    public CompilerConstraint() {
        super("compiler");
    }

    public boolean isSatisfied(Program program) {
        return this.compilerid.equals(program.getCompilerSpec().getCompilerSpecID().getIdAsString());
    }

    public void loadConstraintData(ConstraintData data) {
        this.compilerid = data.getString("id");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompilerConstraint)) {
            return false;
        }
        return ((CompilerConstraint)((Object)obj)).compilerid.equals(this.compilerid);
    }

    public String getDescription() {
        return "compiler = " + this.compilerid;
    }
}

