/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.program.model.address.AddressSetView;
import org.jdom.Content;
import org.jdom.Element;

public class AddressInfo {
    private static final String START_ADDRESS = "START_ADDRESS";
    private static final String END_ADDRESS = "END_ADDRESS";
    static final String VERTEX_ADDRESS_INFO_ELEMENT_NAME = "VERTEX_ADDRESS_INFO";
    String addressRangeStart;
    String addressRangeEnd;

    AddressInfo(FGVertex vertex) {
        if (vertex == null) {
            throw new NullPointerException("Vertex cannot be null");
        }
        AddressSetView addresses = vertex.getAddresses();
        this.addressRangeStart = addresses.getMinAddress().toString();
        this.addressRangeEnd = addresses.getMaxAddress().toString();
    }

    AddressInfo(Element element) {
        this.addressRangeStart = element.getAttributeValue(START_ADDRESS);
        this.addressRangeEnd = element.getAttributeValue(END_ADDRESS);
        if (this.addressRangeStart == null) {
            throw new NullPointerException("Error reading XML for " + this.getClass().getName());
        }
        if (this.addressRangeEnd == null) {
            throw new NullPointerException("Error reading XML for " + this.getClass().getName());
        }
    }

    void write(Element parent) {
        Element element = new Element(VERTEX_ADDRESS_INFO_ELEMENT_NAME);
        element.setAttribute(START_ADDRESS, this.addressRangeStart);
        element.setAttribute(END_ADDRESS, this.addressRangeEnd);
        parent.addContent((Content)element);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[start=" + this.addressRangeStart + ", end=" + this.addressRangeEnd + "]";
    }
}

