/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import ghidra.GhidraApplicationLayout;
import ghidra.GhidraJarApplicationLayout;
import ghidra.GhidraRun;
import ghidra.app.util.headless.AnalyzeHeadless;

public class JarRun {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            JarRun.usage();
        }
        GhidraJarApplicationLayout layout = new GhidraJarApplicationLayout();
        if ("-gui".equals(args[0])) {
            new GhidraRun().launch((GhidraApplicationLayout)layout, JarRun.removeArgs(args, 1));
        } else {
            new AnalyzeHeadless().launch((GhidraApplicationLayout)layout, args);
        }
    }

    private static String[] removeArgs(String[] args, int removalCount) {
        String[] newArgs = new String[Math.max(0, args.length - removalCount)];
        if (newArgs.length != 0) {
            System.arraycopy(args, removalCount, newArgs, 0, newArgs.length);
        }
        return newArgs;
    }

    private static void usage() {
        System.out.println("Ghidra GUI Usage:  java -jar <ghidra.jar> -gui [<ghidra-project-file>]");
        AnalyzeHeadless.usage("java -jar <ghidra.jar>");
        System.exit(1);
    }
}

