/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.EmptyAddressIterator;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.ProcessorContextImpl;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeTranslator;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.util.DefaultIntPropertyMap;
import ghidra.program.model.util.IntPropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.ContextEvaluatorAdapter;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NoValueException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public class CallDepthChangeInfo {
    Program program;
    ArrayList<CodeBlock> codeBlocks = new ArrayList();
    ArrayList<Address> callLocs = new ArrayList();
    IntPropertyMap changeMap;
    IntPropertyMap depthMap;
    private HashMap<Address, Integer> overrideMap = new HashMap();
    private VarnodeTranslator trans;
    private Register stackReg = null;
    private Register frameReg = null;
    SymbolicPropogator symEval = null;
    private int stackPurge = Integer.MAX_VALUE;
    private static final String STACK_DEPTH_CHANGE_NAME = "StackDepthChange";

    public CallDepthChangeInfo(Function func) {
        this.program = func.getProgram();
        this.frameReg = this.program.getCompilerSpec().getStackPointer();
        try {
            this.initialize(func, func.getBody(), this.frameReg, TaskMonitorAdapter.DUMMY_MONITOR);
        }
        catch (CancelledException e) {
            throw new RuntimeException("Unexpected Exception", e);
        }
    }

    public CallDepthChangeInfo(Function func, TaskMonitor monitor) throws CancelledException {
        this(func, func.getBody(), null, monitor);
    }

    public CallDepthChangeInfo(Function function, AddressSetView restrictSet, Register frameReg, TaskMonitor monitor) throws CancelledException {
        this.program = function.getProgram();
        if (frameReg == null) {
            frameReg = this.program.getCompilerSpec().getStackPointer();
        }
        this.initialize(function, restrictSet, frameReg, monitor);
    }

    public CallDepthChangeInfo(Program program, Address addr, AddressSetView restrictSet, Register frameReg, TaskMonitor monitor) throws CancelledException {
        Function func = program.getFunctionManager().getFunctionContaining(addr);
        Register stackReg = program.getCompilerSpec().getStackPointer();
        this.initialize(func, restrictSet, stackReg, monitor);
    }

    private void initialize(Function func, AddressSetView restrictSet, Register reg, TaskMonitor monitor) throws CancelledException {
        this.changeMap = new DefaultIntPropertyMap("change");
        this.depthMap = new DefaultIntPropertyMap("depth");
        this.trans = new VarnodeTranslator(this.program);
        this.symEval = new SymbolicPropogator(this.program);
        this.symEval.setParamRefCheck(false);
        this.symEval.setReturnRefCheck(false);
        this.symEval.setStoredRefCheck(false);
        this.frameReg = reg;
        this.followFlows(func, restrictSet, monitor);
    }

    public int getCallChange(Address addr) {
        int i = Integer.MAX_VALUE;
        try {
            i = this.changeMap.getInt(addr);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        return i;
    }

    void setDepth(Instruction instr, int depth) {
        this.depthMap.add(instr.getMinAddress(), depth);
    }

    void setDepth(Address addr, int depth) {
        this.depthMap.add(addr, depth);
    }

    public int getDepth(Address addr) {
        int depth = Integer.MAX_VALUE;
        try {
            depth = this.depthMap.getInt(addr);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        return depth;
    }

    public int getInstructionStackDepthChange(Instruction instr) {
        return this.getInstructionStackDepthChange(instr, null, 0);
    }

    int getInstructionStackDepthChange(Instruction instr, ProcessorContext procContext, int currentStackDepth) {
        Integer override = this.overrideMap.get(instr.getMinAddress());
        if (override != null) {
            return override;
        }
        int depthChange = 0;
        if (!this.trans.supportsPcode()) {
            return Integer.MAX_VALUE;
        }
        int possibleDepthChange = 0;
        FlowType flowType = instr.getFlowType();
        if (flowType.isCall()) {
            return 0;
        }
        PcodeOp[] pcode = instr.getPcode();
        Varnode outVarNode = null;
        block11: for (PcodeOp op : pcode) {
            Varnode input0 = op.getInput(0);
            Varnode input1 = op.getInput(1);
            Varnode output = op.getOutput();
            switch (op.getOpcode()) {
                case 19: {
                    if (this.isStackPointer(input0)) {
                        possibleDepthChange = (int)input1.getOffset();
                        outVarNode = output;
                        break;
                    }
                    if (input0.equals(outVarNode)) {
                        possibleDepthChange += (int)input1.getOffset();
                        outVarNode = output;
                        break;
                    }
                    if (this.isStackPointer(input1)) {
                        possibleDepthChange = (int)input0.getOffset();
                        outVarNode = output;
                        break;
                    }
                    if (!input1.equals((Object)outVarNode)) break;
                    possibleDepthChange += (int)input0.getOffset();
                    outVarNode = output;
                    break;
                }
                case 20: {
                    if (this.isStackPointer(input0)) {
                        possibleDepthChange = (int)(-input1.getOffset());
                        outVarNode = output;
                        break;
                    }
                    if (input0.equals(outVarNode)) {
                        possibleDepthChange += (int)(-input1.getOffset());
                        outVarNode = output;
                        break;
                    }
                    if (this.isStackPointer(input1)) {
                        possibleDepthChange = (int)(-input0.getOffset());
                        outVarNode = output;
                        break;
                    }
                    if (!input1.equals((Object)outVarNode)) break;
                    possibleDepthChange += (int)(-input0.getOffset());
                    outVarNode = output;
                    break;
                }
                case 27: {
                    if (this.isStackPointer(input0)) {
                        if (currentStackDepth != Integer.MAX_VALUE) {
                            possibleDepthChange = (int)((long)currentStackDepth & input1.getOffset()) - currentStackDepth;
                        }
                        outVarNode = output;
                        break;
                    }
                    if (input0.equals(outVarNode)) {
                        possibleDepthChange = 0;
                        outVarNode = output;
                        break;
                    }
                    if (this.isStackPointer(input1)) {
                        if (currentStackDepth != Integer.MAX_VALUE) {
                            possibleDepthChange = (int)((long)currentStackDepth & input0.getOffset()) - currentStackDepth;
                        }
                        outVarNode = output;
                        break;
                    }
                    if (!input1.equals((Object)outVarNode)) break;
                    possibleDepthChange = 0;
                    outVarNode = output;
                }
            }
            if (!this.isStackPointer(output)) continue;
            switch (op.getOpcode()) {
                case 19: 
                case 20: 
                case 27: {
                    depthChange += possibleDepthChange;
                    continue block11;
                }
                case 3: {
                    continue block11;
                }
                case 28: {
                    Varnode orInput1 = op.getInput(0);
                    Varnode orInput2 = op.getInput(1);
                    if (!orInput1.equals((Object)orInput2)) continue block11;
                    Msg.debug((Object)this, (Object)("INT_OR" + instr.getMinAddress()));
                }
                case 1: {
                    Varnode input = op.getInput(0);
                    if (procContext != null && input.isRegister()) {
                        Register reg = null;
                        reg = this.trans.getRegister(input);
                        if (procContext.hasValue(reg)) {
                            long value = procContext.getValue(reg, true).longValue();
                            depthChange = (int)(value - (long)currentStackDepth);
                            currentStackDepth += depthChange;
                            continue block11;
                        }
                    }
                    if (!input.equals((Object)outVarNode)) {
                        return Integer.MAX_VALUE;
                    }
                    depthChange = possibleDepthChange;
                    continue block11;
                }
                default: {
                    return Integer.MAX_VALUE;
                }
            }
        }
        if (flowType.isTerminal()) {
            depthChange -= this.program.getCompilerSpec().getDefaultCallingConvention().getStackshift();
        }
        if (currentStackDepth == Integer.MAX_VALUE || currentStackDepth == 0x7FFFFFFE) {
            return Integer.MAX_VALUE;
        }
        return depthChange;
    }

    boolean isStackPointer(Varnode output) {
        if (output == null) {
            return false;
        }
        Register reg = null;
        reg = this.trans.getRegister(output);
        return reg == this.stackReg;
    }

    private int getDefaultStackDepthChange(int depth) {
        PrototypeModel defaultModel = this.program.getCompilerSpec().getDefaultCallingConvention();
        int callStackMod = defaultModel.getExtrapop();
        int callStackShift = defaultModel.getStackshift();
        if (callStackMod != 32768 && callStackShift >= 0) {
            return callStackShift - callStackMod;
        }
        return depth;
    }

    public static Integer getStackDepthChange(Program program, Address address) {
        PropertyMapManager pmm = program.getUsrPropertyManager();
        IntPropertyMap ipm = pmm.getIntPropertyMap(STACK_DEPTH_CHANGE_NAME);
        if (ipm == null || !ipm.hasProperty(address)) {
            return null;
        }
        try {
            return ipm.getInt(address);
        }
        catch (NoValueException e) {
            throw new AssertException("Already checked that it has a property");
        }
    }

    public static void setStackDepthChange(Program program, Address address, int stackDepthChange) throws DuplicateNameException {
        PropertyMapManager pmm = program.getUsrPropertyManager();
        IntPropertyMap ipm = pmm.getIntPropertyMap(STACK_DEPTH_CHANGE_NAME);
        if (ipm == null) {
            ipm = pmm.createIntPropertyMap(STACK_DEPTH_CHANGE_NAME);
        }
        ipm.add(address, stackDepthChange);
    }

    public static boolean removeStackDepthChange(Program program, Address address) {
        PropertyMapManager pmm = program.getUsrPropertyManager();
        IntPropertyMap ipm = pmm.getIntPropertyMap(STACK_DEPTH_CHANGE_NAME);
        if (ipm != null) {
            return ipm.remove(address);
        }
        return false;
    }

    public static AddressIterator getStackDepthChanges(Program program, AddressSetView addressSet) {
        PropertyMapManager pmm = program.getUsrPropertyManager();
        IntPropertyMap ipm = pmm.getIntPropertyMap(STACK_DEPTH_CHANGE_NAME);
        if (ipm == null) {
            return new EmptyAddressIterator();
        }
        return ipm.getPropertyIterator(addressSet);
    }

    public int smoothDepth(Program program1, Function func, TaskMonitor monitor) {
        if (this.trans.supportsPcode()) {
            return this.smoothPcodeDepth(program1, func, monitor);
        }
        int returnStackDepth = 0x7FFFFFFE;
        ArrayList<Address> terminalPoints = new ArrayList<Address>();
        Stack<Object> st = new Stack<Object>();
        st.push(func.getEntryPoint());
        st.push(new Integer(0));
        st.push(Boolean.TRUE);
        ProcessorContextImpl procContext = new ProcessorContextImpl(this.trans.getRegisters());
        AddressSet undone = new AddressSet(func.getBody());
        AddressSet badStackSet = new AddressSet((AddressSetView)undone);
        while (!st.empty()) {
            FlowType flow;
            int instrChangeDepth;
            Boolean stackOK = (Boolean)st.pop();
            int stackPointerDepth = (Integer)st.pop();
            Address loc = (Address)st.pop();
            if (!undone.contains(loc)) continue;
            undone.deleteRange(loc, loc);
            Instruction instr = program1.getListing().getInstructionAt(loc);
            if (instr == null) continue;
            if (stackOK == Boolean.TRUE) {
                this.setDepth(instr, stackPointerDepth);
            }
            if ((instrChangeDepth = this.getInstructionStackDepthChange(instr, (ProcessorContext)procContext, stackPointerDepth)) != Integer.MAX_VALUE && instrChangeDepth != 0x7FFFFFFE) {
                stackPointerDepth += instrChangeDepth;
            } else {
                stackOK = Boolean.FALSE;
            }
            if (stackOK == Boolean.TRUE) {
                badStackSet.deleteRange(instr.getMinAddress(), instr.getMaxAddress());
            }
            if (!(flow = instr.getFlowType()).isCall()) {
                Address[] flows;
                for (Address flow2 : flows = instr.getFlows()) {
                    st.push(flow2);
                    st.push(new Integer(stackPointerDepth));
                    st.push(stackOK);
                }
            } else {
                int callStackChange = this.getCallChange(instr.getMinAddress());
                if (callStackChange == Integer.MAX_VALUE || callStackChange == 0x7FFFFFFE) {
                    stackOK = Boolean.FALSE;
                } else if (stackOK == Boolean.TRUE) {
                    stackPointerDepth += callStackChange;
                }
            }
            Address fallThru = instr.getFallThrough();
            if (fallThru != null) {
                st.push(fallThru);
                st.push(new Integer(stackPointerDepth));
                st.push(stackOK);
            }
            if (!flow.isTerminal()) continue;
            int instrPurge = this.getInstructionStackDepthChange(instr, (ProcessorContext)procContext, returnStackDepth);
            if (stackOK.booleanValue()) {
                returnStackDepth = stackPointerDepth - instrPurge;
                continue;
            }
            returnStackDepth = -instrPurge;
            terminalPoints.add(instr.getMinAddress());
        }
        return returnStackDepth;
    }

    private void followFlows(Function func, AddressSetView restrictSet, TaskMonitor monitor) throws CancelledException {
        if (this.frameReg == null) {
            return;
        }
        if (func.isThunk()) {
            return;
        }
        short purge = (short)this.program.getCompilerSpec().getDefaultCallingConvention().getExtrapop();
        final boolean possiblePurge = purge == -1 || purge > 3200 || purge < -3200;
        ContextEvaluatorAdapter eval = new ContextEvaluatorAdapter(){

            @Override
            public boolean evaluateContextBefore(VarnodeContext context, Instruction instr) {
                Varnode stackRegVarnode = context.getRegisterVarnode(CallDepthChangeInfo.this.frameReg);
                Varnode stackValue = null;
                try {
                    stackValue = context.getValue(stackRegVarnode, true, this);
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
                if (stackValue != null && context.isSymbol(stackValue) && stackValue.getAddress().getAddressSpace().getName().equals(CallDepthChangeInfo.this.stackReg.getName())) {
                    int stackPointerDepth = (int)stackValue.getOffset();
                    CallDepthChangeInfo.this.setDepth(instr, stackPointerDepth);
                }
                return false;
            }

            @Override
            public boolean evaluateContext(VarnodeContext context, Instruction instr) {
                FlowType ftype = instr.getFlowType();
                if (possiblePurge && ftype.isTerminal() && instr.getMnemonicString().compareToIgnoreCase("ret") == 0) {
                    int tempPurge = 0;
                    Scalar scalar = instr.getScalar(0);
                    CallDepthChangeInfo.this.stackPurge = scalar != null ? (tempPurge = (int)scalar.getSignedValue()) : 0;
                }
                return false;
            }

            @Override
            public boolean evaluateSymbolicReference(VarnodeContext context, Instruction instr, Address address) {
                if (instr.getFlowType().isTerminal()) {
                    return false;
                }
                this.checkForStackOffset(context, instr, address, -1);
                return false;
            }

            private void checkForStackOffset(VarnodeContext context, Instruction instr, Address address, int opIndex) {
                AddressSpace space = address.getAddressSpace();
                if (space.getName().startsWith("track_") || space.getName().equals(CallDepthChangeInfo.this.stackReg.getName())) {
                    // empty if block
                }
            }
        };
        this.stackReg = this.program.getLanguage().getDefaultCompilerSpec().getStackPointer();
        if (this.stackReg == null) {
            return;
        }
        this.symEval.setRegister(func.getEntryPoint(), this.stackReg);
        this.setDepth(func.getEntryPoint(), 0);
        this.symEval.flowConstants(func.getEntryPoint(), restrictSet, (ContextEvaluator)eval, true, monitor);
    }

    public int getStackPurge() {
        return this.stackPurge;
    }

    public int getStackOffset(Instruction cu, int opIndex) {
        int offset = 0;
        int offsetReg = 0;
        Register offReg = null;
        Scalar s = null;
        Object[] obj = cu.getOpObjects(opIndex);
        for (int i = 0; obj != null && i < obj.length; ++i) {
            if (obj[i] instanceof Scalar) {
                Scalar newsc = (Scalar)obj[i];
                if (s != null) {
                    return 0x7FFFFFFE;
                }
                if ((long)Math.abs(offset) < newsc.getUnsignedValue()) {
                    offset = (int)newsc.getSignedValue();
                    s = newsc;
                }
            }
            if (!(obj[i] instanceof Register)) continue;
            Register reg = (Register)obj[i];
            int depth = this.getRegDepth(cu.getMinAddress(), reg);
            if (depth == 0x7FFFFFFE || depth == Integer.MAX_VALUE) continue;
            offReg = reg;
            offsetReg = depth;
        }
        if (offReg == null || s == null) {
            return 0x7FFFFFFE;
        }
        return offset += offsetReg;
    }

    public int getSPDepth(Address addr) {
        return this.getRegDepth(addr, this.stackReg);
    }

    public int getRegDepth(Address addr, Register reg) {
        SymbolicPropogator.Value rValue;
        Instruction instr = this.program.getListing().getInstructionAt(addr);
        if (instr != null && instr.getLength() < 2) {
            Address fallAddr = instr.getFallFrom();
            if (fallAddr != null) {
                addr = fallAddr;
            }
            instr = this.program.getListing().getInstructionAt(addr);
            addr = instr.getMaxAddress();
        }
        if ((rValue = this.symEval.getRegisterValue(addr, reg)) == null) {
            return 0x7FFFFFFE;
        }
        Register relativeReg = rValue.getRelativeRegister();
        if (!reg.equals((Object)this.stackReg) ? relativeReg == null || !relativeReg.equals((Object)this.stackReg) : relativeReg != null && !relativeReg.equals((Object)this.stackReg)) {
            return 0x7FFFFFFE;
        }
        return (int)rValue.getValue();
    }

    public String getRegValueRepresentation(Address addr, Register reg) {
        return this.symEval.getRegisterValueRepresentation(addr, reg);
    }

    private int smoothPcodeDepth(Program program1, Function func, TaskMonitor monitor) {
        int returnStackDepth = 0x7FFFFFFE;
        ArrayList<Address> terminalPoints = new ArrayList<Address>();
        Stack<Object> st = new Stack<Object>();
        st.push(func.getEntryPoint());
        st.push(new Integer(0));
        st.push(Boolean.TRUE);
        ProcessorContextImpl procContext = new ProcessorContextImpl(this.trans.getRegisters());
        AddressSet undone = new AddressSet(func.getBody());
        AddressSet badStackSet = new AddressSet((AddressSetView)undone);
        while (!st.empty()) {
            FlowType flow;
            int instrChangeDepth;
            Boolean stackOK = (Boolean)st.pop();
            int stackPointerDepth = (Integer)st.pop();
            Address loc = (Address)st.pop();
            if (!undone.contains(loc)) continue;
            undone.deleteRange(loc, loc);
            Instruction instr = program1.getListing().getInstructionAt(loc);
            if (instr == null) continue;
            if (stackOK == Boolean.TRUE) {
                this.setDepth(instr, stackPointerDepth);
            }
            if ((instrChangeDepth = this.getInstructionStackDepthChange(instr, (ProcessorContext)procContext, stackPointerDepth)) != Integer.MAX_VALUE) {
                stackPointerDepth += instrChangeDepth;
            } else {
                stackOK = Boolean.FALSE;
            }
            if (stackOK == Boolean.TRUE) {
                badStackSet.deleteRange(instr.getMinAddress(), instr.getMaxAddress());
            }
            if (!(flow = instr.getFlowType()).isCall()) {
                Address[] flows;
                for (Address flow2 : flows = instr.getFlows()) {
                    st.push(flow2);
                    st.push(new Integer(stackPointerDepth));
                    st.push(stackOK);
                }
            } else {
                int callStackChange = this.getCallPurge(instr);
                if (callStackChange == Integer.MAX_VALUE) {
                    callStackChange = this.getCallChange(instr.getMinAddress());
                }
                if (callStackChange == Integer.MAX_VALUE) {
                    stackOK = Boolean.FALSE;
                } else if (stackOK == Boolean.TRUE) {
                    stackPointerDepth += callStackChange;
                }
            }
            Address fallThru = instr.getFallThrough();
            if (fallThru != null) {
                st.push(fallThru);
                st.push(new Integer(stackPointerDepth));
                st.push(stackOK);
            }
            if (!flow.isTerminal()) continue;
            if (stackOK == Boolean.TRUE) {
                returnStackDepth = stackPointerDepth;
                continue;
            }
            if (instr.getScalar(0) != null) {
                returnStackDepth = (int)instr.getScalar(0).getSignedValue();
                continue;
            }
            terminalPoints.add(instr.getMinAddress());
        }
        return returnStackDepth;
    }

    private int getCallPurge(Instruction instr) {
        Address[] flows;
        Integer override = this.overrideMap.get(instr.getMinAddress());
        if (override != null) {
            return override;
        }
        FlowType fType = instr.getFlowType();
        if (fType.isComputed()) {
            Reference[] refs = instr.getReferencesFrom();
            flows = new Address[refs.length];
            for (int ri = 0; ri < refs.length; ++ri) {
                Reference pointerRef;
                Data data = this.program.getListing().getDataAt(refs[ri].getToAddress());
                if (data == null || !data.isPointer() || (pointerRef = data.getPrimaryReference(0)) == null) continue;
                flows[ri] = pointerRef.getToAddress();
            }
        } else {
            flows = instr.getFlows();
        }
        for (Address flow : flows) {
            Function func;
            if (flow == null || (func = this.program.getListing().getFunctionAt(flow)) == null) continue;
            int purge = func.getStackPurgeSize();
            if (!func.isStackPurgeSizeValid() || purge == Integer.MAX_VALUE || purge == 0x7FFFFFFE) continue;
            return purge;
        }
        return this.getDefaultStackDepthChange(Integer.MAX_VALUE);
    }
}

