/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.util.datatype.EmptyCompositeException;
import ghidra.program.model.data.InvalidDataTypeException;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class ApplyAction
extends CompositeEditorTableAction {
    private static final String GROUP_NAME = "1_BASIC_EDITOR_ACTION";
    private static final ImageIcon APPLY_ICON = ResourceManager.loadImage((String)"images/disk.png");
    private static final String[] popupPath = new String[]{"Apply Edits"};

    public ApplyAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Apply Editor Changes", GROUP_NAME, popupPath, null, APPLY_ICON);
        this.setDescription("Apply editor changes");
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        if (!this.model.isValidName()) {
            this.model.setStatus("Name is not valid.", true);
            return;
        }
        try {
            this.model.apply();
        }
        catch (EmptyCompositeException e1) {
            this.model.setStatus(e1.getMessage(), true);
        }
        catch (InvalidDataTypeException e1) {
            this.model.setStatus(e1.getMessage(), true);
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        boolean hasChanges = this.model.hasChanges();
        boolean validName = this.model.isValidName();
        this.setEnabled(hasChanges && validName);
    }
}

