/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.actions.AbstractTypeDefAction;
import ghidra.app.plugin.core.datamgr.actions.CreateTypeDefDialog;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.BuiltInArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.HelpLocation;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class CreateTypeDefFromDialogAction
extends AbstractTypeDefAction {
    private static final String NAME = "Create Typedef From Dialog";

    public CreateTypeDefFromDialogAction(DataTypeManagerPlugin plugin) {
        super(NAME, plugin);
        this.setPopupMenuData(new MenuData(new String[]{"New", "Typedef..."}, null, "Create"));
    }

    public void actionPerformed(ActionContext context) {
        CategoryNode categoryNode = this.getCategoryNode(context);
        Category category = categoryNode.getCategory();
        CreateTypeDefDialog dialog = new CreateTypeDefDialog(this.plugin, category, categoryNode.getTreePath());
        dialog.setHelpLocation(new HelpLocation(this.plugin.getName(), NAME));
        this.plugin.getTool().showDialog((DialogComponentProvider)dialog);
        if (dialog.isCancelled()) {
            return;
        }
        String name = dialog.getTypeDefName();
        DataType dataType = dialog.getDataType();
        DataTypeManager dataTypeManager = dialog.getDataTypeManager();
        DataTypeArchiveGTree gTree = (DataTypeArchiveGTree)((Object)context.getContextObject());
        CategoryPath categoryPath = category.getCategoryPath();
        DataType newTypeDef = this.createTypeDef(dataTypeManager, dataType, categoryPath, context, (GTreeNode)categoryNode, name);
        if (newTypeDef == null) {
            return;
        }
        dataTypeManager.flushEvents();
        CategoryNode parentNode = categoryNode;
        String newNodeName = newTypeDef.getName();
        SwingUtilities.invokeLater(() -> CreateTypeDefFromDialogAction.lambda$actionPerformed$0(gTree, (GTreeNode)parentNode, newNodeName));
    }

    public boolean isEnabledForContext(ActionContext context) {
        CategoryNode categoryNode = this.getCategoryNode(context);
        ArchiveNode archiveNode = this.getArchiveNode(categoryNode);
        if (archiveNode instanceof BuiltInArchiveNode) {
            return true;
        }
        return categoryNode != null && categoryNode.isModifiable();
    }

    public boolean isAddToPopup(ActionContext context) {
        CategoryNode categoryNode = this.getCategoryNode(context);
        return categoryNode != null && categoryNode.isEnabled();
    }

    private CategoryNode getCategoryNode(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return null;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return null;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        return this.getCategoryForNode(node);
    }

    private CategoryNode getCategoryForNode(GTreeNode node) {
        while (!(node instanceof CategoryNode) && node != null) {
            node = node.getParent();
        }
        return (CategoryNode)node;
    }

    private ArchiveNode getArchiveNode(CategoryNode categoryNode) {
        for (CategoryNode node = categoryNode; node != null; node = node.getParent()) {
            if (!(node instanceof ArchiveNode)) continue;
            return (ArchiveNode)node;
        }
        return null;
    }

    private static /* synthetic */ void lambda$actionPerformed$0(DataTypeArchiveGTree gTree, GTreeNode parentNode, String newNodeName) {
        gTree.setSeletedNodeByName(parentNode, newNodeName);
    }
}

