/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.ComponentProvider;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProvider;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProviderListener;
import ghidra.app.plugin.core.functioncompare.MappedFunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonPanel;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class FunctionComparisonProviderManager
implements FunctionComparisonProviderListener {
    private HashSet<FunctionComparisonProvider> functionComparisonProviders = new HashSet();
    private ProgramPlugin plugin;
    private PluginTool tool;

    public FunctionComparisonProviderManager(ProgramPlugin plugin) {
        this.plugin = plugin;
        this.tool = plugin.getTool();
    }

    public FunctionComparisonProvider showFunctionComparisonProvider(Function[] functions) {
        FunctionComparisonProvider functionComparisonProvider = this.findFunctionComparisonProvider(functions);
        if (functionComparisonProvider != null) {
            this.tool.toFront((ComponentProvider)functionComparisonProvider);
            return functionComparisonProvider;
        }
        FunctionComparisonProvider provider = new FunctionComparisonProvider((Plugin)this.plugin, functions, (FunctionComparisonProviderListener)this);
        this.functionComparisonProviders.add(provider);
        provider.setVisible(true);
        return provider;
    }

    public FunctionComparisonProvider showFunctionComparisonProvider(Function[] leftFunctions, Function[] rightFunctions) {
        FunctionComparisonProvider functionComparisonProvider = this.findFunctionComparisonProvider(leftFunctions, rightFunctions);
        if (functionComparisonProvider != null) {
            this.tool.toFront((ComponentProvider)functionComparisonProvider);
            return functionComparisonProvider;
        }
        FunctionComparisonProvider provider = new FunctionComparisonProvider(this.plugin, leftFunctions, rightFunctions, this);
        this.functionComparisonProviders.add(provider);
        provider.setVisible(true);
        return provider;
    }

    public FunctionComparisonProvider showFunctionComparisonProvider(HashMap<Function, HashSet<Function>> functionMap) {
        FunctionComparisonProvider functionComparisonProvider = this.findFunctionComparisonProvider(functionMap);
        if (functionComparisonProvider != null) {
            this.tool.toFront((ComponentProvider)functionComparisonProvider);
            return functionComparisonProvider;
        }
        FunctionComparisonProvider provider = new FunctionComparisonProvider((Plugin)this.plugin, functionMap, (FunctionComparisonProviderListener)this);
        this.functionComparisonProviders.add(provider);
        provider.setVisible(true);
        return provider;
    }

    private FunctionComparisonProvider findFunctionComparisonProvider(Function[] functions) {
        for (FunctionComparisonProvider functionComparisonProvider : this.functionComparisonProviders) {
            Object[] panelFunctions;
            MultiFunctionComparisonPanel multiPanel;
            FunctionComparisonPanel functionComparisonPanel = functionComparisonProvider.getComponent();
            if (!(functionComparisonPanel instanceof MultiFunctionComparisonPanel ? (multiPanel = (MultiFunctionComparisonPanel)functionComparisonPanel).matchesTheseFunctions(functions, functions) : Arrays.equals(panelFunctions = functionComparisonPanel.getFunctions(), functions))) continue;
            return functionComparisonProvider;
        }
        return null;
    }

    private FunctionComparisonProvider findFunctionComparisonProvider(Function[] functionsL, Function[] functionsR) {
        for (FunctionComparisonProvider functionComparisonProvider : this.functionComparisonProviders) {
            MultiFunctionComparisonPanel multiPanel;
            FunctionComparisonPanel functionComparisonPanel = functionComparisonProvider.getComponent();
            if (!(functionComparisonPanel instanceof MultiFunctionComparisonPanel) || !(multiPanel = (MultiFunctionComparisonPanel)functionComparisonPanel).matchesTheseFunctions(functionsL, functionsR)) continue;
            return functionComparisonProvider;
        }
        return null;
    }

    private FunctionComparisonProvider findFunctionComparisonProvider(HashMap<Function, HashSet<Function>> functionMap) {
        for (FunctionComparisonProvider functionComparisonProvider : this.functionComparisonProviders) {
            MappedFunctionComparisonPanel mappedPanel;
            FunctionComparisonPanel functionComparisonPanel = functionComparisonProvider.getComponent();
            if (!(functionComparisonPanel instanceof MappedFunctionComparisonPanel) || !(mappedPanel = (MappedFunctionComparisonPanel)functionComparisonPanel).matchesTheseFunctions(functionMap)) continue;
            return functionComparisonProvider;
        }
        return null;
    }

    @Override
    public void providerClosed(FunctionComparisonProvider provider) {
        this.functionComparisonProviders.remove((Object)provider);
    }

    public void closeProviders(Program program) {
        FunctionComparisonProvider[] providers;
        for (FunctionComparisonProvider functionComparisonProvider : providers = this.functionComparisonProviders.toArray(new FunctionComparisonProvider[this.functionComparisonProviders.size()])) {
            functionComparisonProvider.programClosed(program);
        }
    }

    public void dispose() {
        for (FunctionComparisonProvider functionComparisonProvider : this.functionComparisonProviders) {
            FunctionComparisonPanel functionComparisonPanel = functionComparisonProvider.getComponent();
            functionComparisonPanel.setVisible(false);
            functionComparisonPanel.dispose();
        }
        this.functionComparisonProviders.clear();
    }

    public void domainObjectRestored(DomainObjectChangedEvent ev) {
        for (DomainObjectChangeRecord domainObjectChangeRecord : ev) {
            Object source;
            int eventType = domainObjectChangeRecord.getEventType();
            if (eventType != 4 || !((source = ev.getSource()) instanceof Program)) continue;
            Program program = (Program)source;
            for (FunctionComparisonProvider functionComparisonProvider : this.functionComparisonProviders) {
                functionComparisonProvider.programRestored(program);
            }
        }
    }
}

