/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reloc;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.util.NumericUtilities;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;

class RelocationTableModel
extends AddressBasedTableModel<Relocation> {
    static final String RELOCATION_ADDRESS = "Address";
    static final String RELOCATION_TYPE = "Type";
    static final String RELOCATION_VALUE = "Values";
    static final String RELOCATION_BYTES = "Original Bytes";
    static final String RELOCATION_NAME = "Name";

    public RelocationTableModel(ServiceProvider serviceProvider, Program program, TaskMonitor monitor) {
        super("Relocation Table Model", serviceProvider, program, monitor);
    }

    @Override
    protected TableColumnDescriptor<Relocation> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new RelocationTypeColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new RelocationValueColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new RelocationBytesColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new RelocationNameColumn());
        return descriptor;
    }

    @Override
    public void setProgram(Program p) {
        super.setProgram(p);
        this.reload();
        this.fireTableDataChanged();
    }

    protected void doLoad(Accumulator<Relocation> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.getProgram() == null) {
            return;
        }
        RelocationTable relocationTable = this.getProgram().getRelocationTable();
        Iterator iterator = relocationTable.getRelocations();
        while (iterator.hasNext()) {
            Relocation r = (Relocation)iterator.next();
            accumulator.add((Object)r);
        }
    }

    @Override
    public Address getAddress(int row) {
        Relocation relocation = (Relocation)this.filteredData.get(row);
        return relocation.getAddress();
    }

    private static class RelocationNameColumn
    extends AbstractProgramBasedDynamicTableColumn<Relocation, String> {
        private RelocationNameColumn() {
        }

        public String getColumnName() {
            return RelocationTableModel.RELOCATION_NAME;
        }

        public String getValue(Relocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSymbolName();
        }
    }

    private static class RelocationBytesColumn
    extends AbstractProgramBasedDynamicTableColumn<Relocation, String> {
        private RelocationBytesColumn() {
        }

        public String getColumnName() {
            return RelocationTableModel.RELOCATION_BYTES;
        }

        public String getValue(Relocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return this.packBytes(rowObject.getBytes());
        }

        private String packBytes(byte[] bytes) {
            if (bytes == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            byte[] byArray = bytes;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                String byteStr;
                long b = byArray[i];
                if (buf.length() != 0) {
                    buf.append(' ');
                }
                if ((byteStr = Long.toHexString(b & 0xFFL)).length() == 1) {
                    buf.append('0');
                }
                buf.append(byteStr);
            }
            return buf.toString();
        }
    }

    private static class RelocationValueColumn
    extends AbstractProgramBasedDynamicTableColumn<Relocation, String> {
        private RelocationValueColumn() {
        }

        public String getColumnName() {
            return RelocationTableModel.RELOCATION_VALUE;
        }

        public String getValue(Relocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return this.packValues(rowObject.getValues());
        }

        private String packValues(long[] values) {
            if (values == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            for (long v : values) {
                if (buf.length() != 0) {
                    buf.append(", ");
                }
                buf.append(NumericUtilities.toHexString((long)v));
            }
            return buf.toString();
        }
    }

    private static class RelocationTypeColumn
    extends AbstractProgramBasedDynamicTableColumn<Relocation, String> {
        private RelocationTypeColumn() {
        }

        public String getColumnName() {
            return RelocationTableModel.RELOCATION_TYPE;
        }

        public String getValue(Relocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return "0x" + Integer.toHexString(rowObject.getType());
        }
    }
}

